/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.scare.events;

import java.net.Inet6Address;
import java.net.InetAddress;
import net.knifick.badjoke.BadJokeMod;
import net.knifick.badjoke.init.ModSounds;
import net.knifick.badjoke.network.BadJokeModVariables;
import net.knifick.badjoke.network.payloads.IpRevealPayload;
import net.knifick.badjoke.scare.Event;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.network.PacketDistributor;

public class IpRevealEvent
implements Event {
    @Override
    public void fire(ServerPlayer player) {
        BadJokeModVariables.MapVariables vars = BadJokeModVariables.MapVariables.get((LevelAccessor)player.level());
        if (vars.safe_mode) {
            return;
        }
        String ip = IpRevealEvent.getIPv4(player);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new IpRevealPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        player.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 200, 1));
        BadJokeMod.performCommandAsPlayerSync(player, "/title @a times 0 200 0", true);
        BadJokeMod.performCommandAsPlayerSync(player, "/title @a title {\"text\":\"" + ip + "\"}", true);
    }

    @Override
    public void clientExecution() {
        Minecraft mc = Minecraft.getInstance();
        mc.player.playSound((SoundEvent)ModSounds.IP.get());
    }

    private static String getIPv4(ServerPlayer player) {
        String ip = player.getIpAddress();
        if (ip.startsWith("/")) {
            ip = ip.substring(1);
        }
        if ("<unknown>".equals(ip)) {
            try {
                ip = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                ip = "127.0.0.1";
            }
        }
        try {
            InetAddress addr = InetAddress.getByName(ip);
            if (addr instanceof Inet6Address) {
                byte[] bytes = addr.getAddress();
                if (bytes.length == 16) {
                    boolean isMapped = true;
                    for (int i = 0; i < 10; ++i) {
                        if (bytes[i] == 0) continue;
                        isMapped = false;
                        break;
                    }
                    if (isMapped && bytes[10] == -1 && bytes[11] == -1) {
                        ip = String.format("%d.%d.%d.%d", bytes[12] & 0xFF, bytes[13] & 0xFF, bytes[14] & 0xFF, bytes[15] & 0xFF);
                        return ip;
                    }
                }
                if (addr.isLoopbackAddress()) {
                    ip = "127.0.0.1";
                }
            }
        }
        catch (Exception e) {
            ip = "127.0.0.1";
        }
        return ip;
    }
}

