/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.scare.events;

import java.util.Random;
import net.knifick.badjoke.entity.KukoldJokerEntity;
import net.knifick.badjoke.init.ModEntities;
import net.knifick.badjoke.scare.Event;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class KukoldSpawnerEvent
implements Event {
    private static final Random random = new Random();

    @Override
    public void fire(ServerPlayer player) {
        KukoldSpawnerEvent.tryPlaceSignNearPlayer(player);
    }

    public static void tryPlaceSignNearPlayer(ServerPlayer player) {
        ServerLevel level = player.serverLevel();
        if (level.isClientSide()) {
            return;
        }
        BlockPos playerPos = player.blockPosition();
        boolean isUnderground = KukoldSpawnerEvent.isUnderground((Level)level, playerPos);
        int radius = isUnderground ? 2 : 3;
        int attempts = 50;
        for (int i = 0; i < attempts; ++i) {
            int dx = random.nextInt(radius * 7 + 1) - radius;
            int dz = random.nextInt(radius * 7 + 1) - radius;
            int dy = random.nextInt(5) - 2;
            BlockPos basePos = playerPos.offset(dx, dy - 1, dz);
            BlockPos signPos = basePos.above();
            BlockState baseState = level.getBlockState(basePos);
            BlockState aboveState = level.getBlockState(signPos);
            if (!baseState.isFaceSturdy((BlockGetter)level, basePos, Direction.UP) || !aboveState.isAir()) continue;
            KukoldJokerEntity entity = new KukoldJokerEntity((EntityType<? extends PathfinderMob>)((EntityType)ModEntities.KUKOLD_JOKER.get()), (Level)level);
            entity.setPos(Vec3.atCenterOf((Vec3i)signPos).add(0.0, 0.0, 0.0));
            level.addFreshEntity((Entity)entity);
            Vec3 entityPos = entity.position();
            Vec3 targetVec = Vec3.atCenterOf((Vec3i)signPos);
            double ddx = targetVec.x - entityPos.x;
            double ddy = targetVec.y - (entityPos.y + (double)entity.getEyeHeight());
            double ddz = targetVec.z - entityPos.z;
            double horizontalDistance = Math.sqrt(ddx * ddx + ddz * ddz);
            float yaw = (float)(Mth.atan2((double)(-ddx), (double)ddz) * 57.29577951308232);
            float pitch = (float)(-Mth.atan2((double)ddy, (double)horizontalDistance) * 57.29577951308232);
            entity.setYRot(yaw);
            entity.setXRot(pitch);
            entity.yRotO = yaw;
            entity.xRotO = pitch;
            return;
        }
    }

    private static boolean isUnderground(Level level, BlockPos pos) {
        for (int i = 1; i <= 5; ++i) {
            BlockPos above = pos.above(i);
            if (!level.getBlockState(above).isAir()) continue;
            return false;
        }
        return true;
    }
}

