/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.scare.events;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.knifick.badjoke.client.screen.ScreamerOverlay;
import net.knifick.badjoke.init.ModSounds;
import net.knifick.badjoke.network.BadJokeModVariables;
import net.knifick.badjoke.network.payloads.ScreamerPayload;
import net.knifick.badjoke.scare.Event;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class ScreamerEvent
implements Event {
    private static final ScheduledExecutorService SCHED = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "BadJoke-ScreamerScheduler");
        t.setDaemon(true);
        return t;
    });

    @Override
    public void fire(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ScreamerPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        ScreamerEvent.spawnCreepersNearPlayer((Player)player);
    }

    @Override
    public void clientExecution() {
        boolean withCountdown;
        Minecraft mc = Minecraft.getInstance();
        BadJokeModVariables.MapVariables vars = BadJokeModVariables.MapVariables.get((LevelAccessor)mc.level);
        boolean bl = withCountdown = vars != null && vars.screamer_mode;
        if (withCountdown) {
            ScreamerEvent.showCountdownThenScreamer(mc);
        } else {
            ScreamerOverlay.show();
            if (mc.player != null) {
                mc.player.playSound((SoundEvent)ModSounds.JOKER.get());
            }
        }
    }

    private static void showCountdownThenScreamer(Minecraft mc) {
        ScreamerEvent.sendBigTitle(mc, "\u0421\u043a\u0440\u0438\u043c\u0435\u0440 \u0447\u0435\u0440\u0435\u0437 3");
        SCHED.schedule(() -> mc.execute(() -> ScreamerEvent.sendBigTitle(mc, "\u0421\u043a\u0440\u0438\u043c\u0435\u0440 \u0447\u0435\u0440\u0435\u0437 2")), 1L, TimeUnit.SECONDS);
        SCHED.schedule(() -> mc.execute(() -> ScreamerEvent.sendBigTitle(mc, "\u0421\u043a\u0440\u0438\u043c\u0435\u0440 \u0447\u0435\u0440\u0435\u0437 1")), 2L, TimeUnit.SECONDS);
        SCHED.schedule(() -> mc.execute(() -> {
            ScreamerOverlay.show();
            if (mc.player != null) {
                mc.player.playSound((SoundEvent)ModSounds.JOKER.get());
            }
            mc.gui.clear();
        }), 3L, TimeUnit.SECONDS);
    }

    private static void sendBigTitle(Minecraft mc, String text) {
        mc.gui.setTitle((Component)Component.literal((String)text));
    }

    public static void spawnCreepersNearPlayer(Player player) {
        Level level = player.level();
        if (level.isClientSide || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos playerPos = player.blockPosition();
        int y = playerPos.getY();
        int count = y < 40 ? 1 : (y < 80 ? 2 : 3);
        for (int i = 0; i < count; ++i) {
            Creeper creeper;
            BlockPos spawnPos = ScreamerEvent.findNearbySolidGround(playerPos, serverLevel);
            if (spawnPos == null || (creeper = (Creeper)EntityType.CREEPER.create((Level)serverLevel)) == null) continue;
            creeper.moveTo(Vec3.atBottomCenterOf((Vec3i)spawnPos));
            serverLevel.addFreshEntity((Entity)creeper);
        }
    }

    private static BlockPos findNearbySolidGround(BlockPos center, ServerLevel level) {
        for (int attempts = 0; attempts < 10; ++attempts) {
            int dz;
            int dx = level.getRandom().nextInt(11) - 5;
            BlockPos pos = center.offset(dx, 0, dz = level.getRandom().nextInt(11) - 5);
            BlockPos surface = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos);
            if (!level.getBlockState(surface.below()).isSolidRender((BlockGetter)level, surface.below())) continue;
            return surface;
        }
        return null;
    }
}

