/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.scare.events;

import java.util.Random;
import net.knifick.badjoke.BadJokeMod;
import net.knifick.badjoke.entity.OriginalJokerEntity;
import net.knifick.badjoke.init.ModEntities;
import net.knifick.badjoke.scare.Event;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class SignSpawnerEvent
implements Event {
    private static final Random random = new Random();

    @Override
    public void fire(ServerPlayer player) {
        SignSpawnerEvent.tryPlaceSignNearPlayer(player);
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.AMBIENT_CAVE.value(), SoundSource.HOSTILE, 9.375f, 1.0f);
    }

    public static void tryPlaceSignNearPlayer(ServerPlayer player) {
        ServerLevel level = player.serverLevel();
        if (level.isClientSide()) {
            return;
        }
        BlockPos playerPos = player.blockPosition();
        boolean isUnderground = SignSpawnerEvent.isUnderground((Level)level, playerPos);
        int radius = isUnderground ? 2 : 3;
        int attempts = 50;
        for (int i = 0; i < attempts; ++i) {
            int dx = random.nextInt(radius * 2 + 1) - radius;
            int dz = random.nextInt(radius * 2 + 1) - radius;
            int dy = random.nextInt(5) - 2;
            BlockPos basePos = playerPos.offset(dx, dy - 1, dz);
            BlockPos signPos = basePos.above();
            BlockState baseState = level.getBlockState(basePos);
            BlockState aboveState = level.getBlockState(signPos);
            if (!baseState.isFaceSturdy((BlockGetter)level, basePos, Direction.UP) || !aboveState.isAir()) continue;
            BlockState signState = (BlockState)Blocks.OAK_SIGN.defaultBlockState().setValue((Property)StandingSignBlock.ROTATION, (Comparable)Integer.valueOf(random.nextInt(16)));
            level.setBlock(signPos, signState, 3);
            BlockEntity be = level.getBlockEntity(signPos);
            if (be instanceof SignBlockEntity) {
                SignBlockEntity sign = (SignBlockEntity)be;
                MutableComponent clickableText = Component.literal((String)"CLICK ME").withStyle(Style.EMPTY.withColor(ChatFormatting.RED).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.youtube.com/watch?v=SwWiT31DUfs")));
                Component[] messages = new Component[]{clickableText, Component.empty(), Component.empty(), Component.empty()};
                SignText signText = new SignText(messages, messages, DyeColor.RED, true);
                sign.setText(signText, true);
                sign.setText(signText, false);
                sign.setWaxed(true);
                sign.setChanged();
                level.sendBlockUpdated(signPos, level.getBlockState(signPos), level.getBlockState(signPos), 3);
            }
            OriginalJokerEntity entity = new OriginalJokerEntity((EntityType<? extends PathfinderMob>)((EntityType)ModEntities.ORIGINAL_JOKER.get()), (Level)level);
            entity.setPos(Vec3.atCenterOf((Vec3i)signPos).add(0.0, 0.0, -2.0));
            level.addFreshEntity((Entity)entity);
            Vec3 entityPos = entity.position();
            Vec3 targetVec = Vec3.atCenterOf((Vec3i)signPos);
            double ddx = targetVec.x - entityPos.x;
            double ddy = targetVec.y - (entityPos.y + (double)entity.getEyeHeight());
            double ddz = targetVec.z - entityPos.z;
            double horizontalDistance = Math.sqrt(ddx * ddx + ddz * ddz);
            float yaw = (float)(Mth.atan2((double)(-ddx), (double)ddz) * 57.29577951308232);
            float pitch = (float)(-Mth.atan2((double)ddy, (double)horizontalDistance) * 57.29577951308232);
            entity.setYRot(yaw);
            entity.setXRot(pitch);
            entity.yRotO = yaw;
            entity.xRotO = pitch;
            BadJokeMod.queueServerWork(60, () -> ((OriginalJokerEntity)entity).discard());
            return;
        }
    }

    private static boolean isUnderground(Level level, BlockPos pos) {
        for (int i = 1; i <= 5; ++i) {
            BlockPos above = pos.above(i);
            if (!level.getBlockState(above).isAir()) continue;
            return false;
        }
        return true;
    }
}

