/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.scare.events;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.knifick.badjoke.scare.Event;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class StructureEvent
implements Event {
    private static final List<ResourceLocation> STRUCTURES = List.of(ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"furnace"), ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"face"), ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"face2"), ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"chests"), ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"sheep"), ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"shouse"), ResourceLocation.fromNamespaceAndPath((String)"joke", (String)"sign"));

    @Override
    public void fire(ServerPlayer player) {
        ServerLevel level = player.serverLevel();
        ResourceLocation id = STRUCTURES.get(ThreadLocalRandom.current().nextInt(STRUCTURES.size()));
        Rotation rot = Rotation.values()[ThreadLocalRandom.current().nextInt(Rotation.values().length)];
        Mirror mir = Mirror.NONE;
        BlockPos around = player.blockPosition();
        int radius = 6;
        int x = around.getX() + ThreadLocalRandom.current().nextInt(-radius, radius + 1);
        int z = around.getZ() + ThreadLocalRandom.current().nextInt(-radius, radius + 1);
        StructureEvent.placeOnGround(level, id, new BlockPos(x, 0, z), rot, mir);
    }

    public static void placeOnGround(ServerLevel level, ResourceLocation id, BlockPos cornerXZ, Rotation rot, Mirror mir) {
        StructureTemplateManager manager = level.getStructureManager();
        manager.get(id).ifPresentOrElse(template -> {
            Vec3i raw = template.getSize();
            Vec3i size = StructureEvent.rotatedSize(raw, rot);
            int baseY = StructureEvent.minHeightOverFootprint(level, cornerXZ.getX(), cornerXZ.getZ(), size.getX(), size.getZ());
            BlockPos corner = new BlockPos(cornerXZ.getX(), baseY, cornerXZ.getZ());
            StructurePlaceSettings settings = new StructurePlaceSettings().setRotation(rot).setMirror(mir).setIgnoreEntities(false);
            template.placeInWorld((ServerLevelAccessor)level, corner, corner, settings, level.getRandom(), 2);
        }, () -> System.err.println("[JokeMod] \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0448\u0430\u0431\u043b\u043e\u043d: " + String.valueOf(id)));
    }

    private static Vec3i rotatedSize(Vec3i size, Rotation rot) {
        return switch (rot) {
            default -> throw new MatchException(null, null);
            case Rotation.NONE, Rotation.CLOCKWISE_180 -> size;
            case Rotation.CLOCKWISE_90, Rotation.COUNTERCLOCKWISE_90 -> new Vec3i(size.getZ(), size.getY(), size.getX());
        };
    }

    private static int minHeightOverFootprint(ServerLevel level, int startX, int startZ, int sizeX, int sizeZ) {
        int minY = Integer.MAX_VALUE;
        for (int dz = 0; dz < sizeZ; ++dz) {
            for (int dx = 0; dx < sizeX; ++dx) {
                int x = startX + dx;
                int z = startZ + dz;
                int y = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
                if (y >= minY) continue;
                minY = y;
            }
        }
        return minY == Integer.MAX_VALUE ? 0 : minY;
    }
}

