/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.scare.events;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import net.knifick.badjoke.init.ModBlocks;
import net.knifick.badjoke.mixin.ChunkMapAccessor;
import net.knifick.badjoke.scare.Event;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;

public class TorchOffEvent
implements Event {
    @Override
    public void fire(ServerPlayer player) {
        ServerLevel level = player.serverLevel();
        ChunkMap chunkMap = level.getChunkSource().chunkMap;
        Long2ObjectLinkedOpenHashMap<ChunkHolder> visibleChunks = ((ChunkMapAccessor)chunkMap).getVisibleChunkMap();
        for (ChunkHolder holder : visibleChunks.values()) {
            LevelChunk chunk = holder.getTickingChunk();
            if (chunk == null) continue;
            int startX = chunk.getPos().getMinBlockX();
            int startZ = chunk.getPos().getMinBlockZ();
            for (int x = startX; x < startX + 16; ++x) {
                for (int z = startZ; z < startZ + 16; ++z) {
                    for (int y = level.getMinBuildHeight(); y < level.getMaxBuildHeight(); ++y) {
                        BlockPos pos = new BlockPos(x, y, z);
                        BlockState state = chunk.getBlockState(pos);
                        if (state.is(Blocks.TORCH)) {
                            level.setBlock(pos, ((Block)ModBlocks.EX_TORCH.get()).defaultBlockState(), 3);
                            continue;
                        }
                        if (!state.is(Blocks.WALL_TORCH)) continue;
                        Direction facing = (Direction)state.getValue((Property)WallTorchBlock.FACING);
                        BlockState newState = (BlockState)((Block)ModBlocks.EX_TORCH_WALL.get()).defaultBlockState().setValue((Property)WallTorchBlock.FACING, (Comparable)facing);
                        level.setBlock(pos, newState, 3);
                    }
                }
            }
        }
        level.playSound(null, player.blockPosition(), SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 0.8f);
    }
}

