/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.scare.events;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import net.knifick.badjoke.scare.Event;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class TreeStoneifyEvent
implements Event {
    private static final int RADIUS = 6;
    private static final int DEFAULT_DURATION_TICKS = 600;
    private static final int SAMPLES_PER_TICK = 300;
    private static final int MAX_REPLACEMENTS_PER_TICK = 96;
    private static final Map<UUID, Integer> TIMERS = new ConcurrentHashMap<UUID, Integer>();

    @Override
    public void fire(ServerPlayer player) {
        TreeStoneifyEvent.start(player, 600);
    }

    public static void start(ServerPlayer player, int durationTicks) {
        if (player != null) {
            TIMERS.put(player.getUUID(), Math.max(1, durationTicks));
        }
    }

    public static void stop(ServerPlayer player) {
        if (player != null) {
            TIMERS.remove(player.getUUID());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post evt) {
        Player player = evt.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        ServerLevel level = sp.serverLevel();
        UUID id = sp.getUUID();
        Integer remaining = TIMERS.get(id);
        if (remaining == null || remaining <= 0) {
            TIMERS.remove(id);
            return;
        }
        TIMERS.put(id, remaining - 1);
        BlockPos center = sp.blockPosition();
        int r = 6;
        int r2 = 36;
        int replaced = 0;
        int attempts = 0;
        int maxAttempts = 300;
        while (attempts++ < maxAttempts && replaced < 96) {
            BlockState state;
            BlockPos pos;
            int dz;
            int dy;
            int dx = ThreadLocalRandom.current().nextInt(-6, 7);
            if (dx * dx + (dy = ThreadLocalRandom.current().nextInt(-6, 7)) * dy + (dz = ThreadLocalRandom.current().nextInt(-6, 7)) * dz > 36 || !level.isLoaded(pos = center.offset(dx, dy, dz)) || !(state = level.getBlockState(pos)).is(BlockTags.LOGS) && !state.is(BlockTags.LEAVES)) continue;
            BlockState replacement = TreeStoneifyEvent.randomStone();
            level.setBlock(pos, replacement, 3);
            ++replaced;
        }
    }

    private static BlockState randomStone() {
        int roll = ThreadLocalRandom.current().nextInt(100);
        if (roll < 45) {
            return Blocks.COBBLESTONE.defaultBlockState();
        }
        if (roll < 70) {
            return Blocks.MOSSY_COBBLESTONE.defaultBlockState();
        }
        return Blocks.STONE.defaultBlockState();
    }
}

