/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.scare.events;

import net.knifick.badjoke.init.ModEntities;
import net.knifick.badjoke.init.ModSounds;
import net.knifick.badjoke.scare.Event;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;

public class VictimSpawnEvent
implements Event {
    @Override
    public void fire(ServerPlayer player) {
        ServerLevel level = (ServerLevel)player.level();
        RandomSource random = level.getRandom();
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), ModSounds.BALLOBIK, SoundSource.HOSTILE, 9.375f, 1.0f);
        double distance = Mth.nextDouble((RandomSource)random, (double)32.0, (double)48.0);
        double angle = Mth.nextDouble((RandomSource)random, (double)0.0, (double)(Math.PI * 2));
        int offsetX = Mth.floor((double)(distance * Math.cos(angle)));
        int offsetZ = Mth.floor((double)(distance * Math.sin(angle)));
        BlockPos.MutableBlockPos spawnPos = new BlockPos.MutableBlockPos(player.getX() + (double)offsetX, 0.0, player.getZ() + (double)offsetZ);
        int y = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, spawnPos.getX(), spawnPos.getZ());
        spawnPos.setY(y);
        Entity mob = ((EntityType)ModEntities.VICTIM.get()).create((Level)level);
        if (mob != null) {
            mob.moveTo((double)spawnPos.getX() + 0.5, (double)y, (double)spawnPos.getZ() + 0.5, random.nextFloat() * 360.0f, 0.0f);
            level.addFreshEntity(mob);
        }
    }
}

