/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.scare.events;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.knifick.badjoke.BadJokeMod;
import net.knifick.badjoke.client.WindowsToast;
import net.knifick.badjoke.init.ModSounds;
import net.knifick.badjoke.network.payloads.WinToastPayload;
import net.knifick.badjoke.scare.Event;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class WinToastEvent
implements Event {
    @Override
    public void fire(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new WinToastPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void clientExecution() {
        Minecraft mc = Minecraft.getInstance();
        mc.player.playSound((SoundEvent)ModSounds.DISCORD.get());
        if (!System.getProperty("os.name").toLowerCase().contains("win")) {
            return;
        }
        Path iconPath = null;
        try (InputStream in = BadJokeMod.class.getResourceAsStream("/assets/joke/textures/ava.png");){
            if (in != null) {
                iconPath = Files.createTempFile("wintoastdemo-icon", ".png", new FileAttribute[0]);
                Files.copy(in, iconPath, StandardCopyOption.REPLACE_EXISTING);
                iconPath.toFile().deleteOnExit();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        WindowsToast.notifyAsync("Discord", "JOKER", "Hello", iconPath);
    }
}

