/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.scare.realise;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.knifick.badjoke.entity.ScaryJokeEntity;
import net.knifick.badjoke.network.BadJokeModVariables;
import net.knifick.badjoke.scare.EventSystem;
import net.knifick.badjoke.scare.Events;
import net.knifick.badjoke.scare.PhonePhrases;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber
public class PhrasesTrigger {
    private static final Map<PhonePhrases, String[]> STRUCTURE_TRIGGERS = Map.of(PhonePhrases.village, new String[]{"minecraft:village_plains", "minecraft:village_savanna", "minecraft:village_desert", "minecraft:village_taiga", "minecraft:village_snowy"}, PhonePhrases.end_city, new String[]{"minecraft:end_city"}, PhonePhrases.deep_dark, new String[]{"minecraft:ancient_city"});

    @SubscribeEvent
    public static void playerTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        BadJokeModVariables.PlayerVariables vars = (BadJokeModVariables.PlayerVariables)player.getData(BadJokeModVariables.PLAYER_VARIABLES);
        STRUCTURE_TRIGGERS.forEach((phrase, ids) -> {
            if (!vars.seen.contains(phrase) && PhrasesTrigger.isPlayerInStructure((Player)player, ids)) {
                PhrasesTrigger.triggerPhraseOnce(player, phrase, vars);
            }
        });
    }

    private static boolean isPlayerInStructure(Player player, String[] structureIds) {
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel level2 = (ServerLevel)level;
        BlockPos pos = player.blockPosition();
        StructureManager manager = level2.structureManager();
        RegistryAccess access = level2.registryAccess();
        Registry registry = access.registryOrThrow(Registries.STRUCTURE);
        for (String id : structureIds) {
            Structure structure;
            StructureStart start;
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.parse((String)id));
            Optional holderOpt = registry.getHolder(key);
            if (holderOpt.isEmpty() || (start = manager.getStructureAt(pos, structure = (Structure)((Holder.Reference)holderOpt.get()).value())) == null || !start.isValid()) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onVillagerKill(LivingDeathEvent event) {
        if (!(event.getEntity() instanceof Villager)) {
            return;
        }
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        List<PhonePhrases> phrases = List.of(PhonePhrases.kill_villager1, PhonePhrases.kill_villager2, PhonePhrases.kill_villager3);
        BadJokeModVariables.PlayerVariables vars = (BadJokeModVariables.PlayerVariables)player.getData(BadJokeModVariables.PLAYER_VARIABLES);
        List<PhonePhrases> unseen = phrases.stream().filter(p -> !vars.seen.contains(p)).toList();
        if (unseen.isEmpty()) {
            return;
        }
        RandomSource random = player.level().random;
        PhonePhrases chosen = unseen.get(random.nextInt(unseen.size()));
        Events.addReputation(player, -1.0f);
        PhrasesTrigger.triggerPhraseOnce(player, chosen, vars);
    }

    @SubscribeEvent
    public static void onCreeperKill(LivingDeathEvent event) {
        ServerPlayer player;
        block3: {
            block2: {
                PhrasesTrigger.triggerIfMatch(event, Creeper.class, PhonePhrases.creeper);
                Entity entity = event.getSource().getEntity();
                if (!(entity instanceof ServerPlayer)) break block2;
                player = (ServerPlayer)entity;
                if (event.getEntity() instanceof Creeper) break block3;
            }
            return;
        }
        Events.addReputation(player, 0.1f);
    }

    @SubscribeEvent
    public static void onMonsterKill(LivingDeathEvent event) {
        ServerPlayer player;
        block3: {
            block2: {
                Entity entity = event.getSource().getEntity();
                if (!(entity instanceof ServerPlayer)) break block2;
                player = (ServerPlayer)entity;
                if (event.getEntity() instanceof Monster) break block3;
            }
            return;
        }
        Events.addReputation(player, 0.1f);
    }

    @SubscribeEvent
    public static void onMeatKill(LivingDeathEvent event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (event.getEntity() instanceof Chicken || event.getEntity() instanceof Cow || event.getEntity() instanceof Pig || event.getEntity() instanceof Sheep) {
            Events.addReputation(player, -0.5f);
            PhrasesTrigger.triggerIfMatch(player, PhonePhrases.meat);
        }
    }

    @SubscribeEvent
    public static void onLongJokeKill(LivingDeathEvent event) {
        ServerPlayer player;
        block3: {
            block2: {
                PhrasesTrigger.triggerIfMatch(event, ScaryJokeEntity.class, PhonePhrases.long_joke);
                Entity entity = event.getSource().getEntity();
                if (!(entity instanceof ServerPlayer)) break block2;
                player = (ServerPlayer)entity;
                if (event.getEntity() instanceof ScaryJokeEntity) break block3;
            }
            return;
        }
        Events.addReputation(player, -1.0f);
    }

    private static <T> void triggerIfMatch(LivingDeathEvent event, Class<T> entityClass, PhonePhrases phrase) {
        if (!entityClass.isInstance(event.getEntity())) {
            return;
        }
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        PhrasesTrigger.triggerIfMatch(player, phrase);
    }

    public static void triggerIfMatch(ServerPlayer player, PhonePhrases phrase) {
        BadJokeModVariables.PlayerVariables vars = (BadJokeModVariables.PlayerVariables)player.getData(BadJokeModVariables.PLAYER_VARIABLES);
        if (!vars.seen.contains((Object)phrase)) {
            PhrasesTrigger.triggerPhraseOnce(player, phrase, vars);
        }
    }

    private static void triggerPhraseOnce(ServerPlayer player, PhonePhrases phrase, BadJokeModVariables.PlayerVariables vars) {
        EventSystem.runEvent(Events.CallEvent, player, phrase);
        vars.seen.add(phrase);
        vars.syncPlayerVariables((Entity)player);
    }

    @SubscribeEvent
    public static void abyssTrigger(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        PhonePhrases phrase = PhonePhrases.abyss_player;
        if (player.getY() < -65.0) {
            PhrasesTrigger.triggerIfMatch(player, phrase);
        }
    }

    @SubscribeEvent
    public static void bedrockTrigger(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        PhonePhrases phrase = PhonePhrases.bedrock;
        BlockPos blockBelow = player.blockPosition().below();
        BlockState stateBelow = player.level().getBlockState(blockBelow);
        if (stateBelow.is(Blocks.BEDROCK)) {
            PhrasesTrigger.triggerIfMatch(player, phrase);
        }
    }

    @SubscribeEvent
    public static void underZeroTrigger(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        PhonePhrases phrase = PhonePhrases.under_zero;
        if (player.getY() <= -1.0) {
            PhrasesTrigger.triggerIfMatch(player, phrase);
        }
    }

    @SubscribeEvent
    public static void netherTrigger(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        PhonePhrases phrase = PhonePhrases.nether;
        if (player.level().dimension() == Level.NETHER) {
            PhrasesTrigger.triggerIfMatch(player, phrase);
        }
    }

    @SubscribeEvent
    public static void endTrigger(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        PhonePhrases phrase = PhonePhrases.end;
        if (player.level().dimension() == Level.END) {
            PhrasesTrigger.triggerIfMatch(player, phrase);
        }
    }
}

