/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber
public class RisingRingParticles {
    private static final List<Active> ACTIVE = new LinkedList<Active>();

    public static void startRisingRing(Entity target, ParticleOptions particle, double radius, int points, double upSpeed) {
        Level level = target.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        ACTIVE.add(new Active(sl, target.getId(), particle, radius, points, upSpeed, 40));
    }

    @SubscribeEvent
    public static void onLevelTick(LevelTickEvent.Post e) {
        if (e.getLevel().isClientSide()) {
            return;
        }
        Iterator<Active> it = ACTIVE.iterator();
        while (it.hasNext()) {
            Active a = it.next();
            if (a.level.isClientSide() || a.ticksLeft-- <= 0) {
                it.remove();
                continue;
            }
            Entity ent = a.level.getEntity(a.entityId);
            if (ent == null || !ent.isAlive()) {
                it.remove();
                continue;
            }
            double spin = (double)a.age++ * 0.15;
            double cx = ent.getX();
            double cy = ent.getY() + (double)ent.getBbHeight() * 0.5;
            double cz = ent.getZ();
            for (int i = 0; i < a.points; ++i) {
                double angle = spin + Math.PI * 2 * (double)i / (double)a.points;
                double x = cx + a.radius * Math.cos(angle);
                double z = cz + a.radius * Math.sin(angle);
                a.level.sendParticles(a.particle, x, cy, z, 1, 0.0, 0.0, 0.0, a.upSpeed);
            }
        }
    }

    private static final class Active {
        final ServerLevel level;
        final int entityId;
        final ParticleOptions particle;
        final double radius;
        final int points;
        final double upSpeed;
        int ticksLeft;
        int age = 0;

        Active(ServerLevel level, int entityId, ParticleOptions particle, double radius, int points, double upSpeed, int durationTicks) {
            this.level = level;
            this.entityId = entityId;
            this.particle = particle;
            this.radius = radius;
            this.points = points;
            this.upSpeed = upSpeed;
            this.ticksLeft = durationTicks;
        }
    }
}

