/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.badjoke.winadditions;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadLocalRandom;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import net.minecraft.client.Minecraft;

public final class EyeWindow
extends JFrame {
    private static final String EYE_PATH = "/assets/joke/textures/screens/eye.png";
    private static final String DOT_PATH = "/assets/joke/textures/screens/eye_dot.png";
    private static final int TICK_FPS = 60;
    private static final int EYE_FRAME_MS = 100;
    private static final int DOT_FRAME_MS = 150;
    private final int eyeFrameW;
    private final int eyeFrameH;
    private final int eyeFrames;
    private final int dotFrameW;
    private final int dotFrameH;
    private final int dotFrames;
    private final BufferedImage eyeSheet;
    private final BufferedImage dotSheet;
    private int eyeFrameIndex = 0;
    private int dotFrameIndex = 0;
    private long lastEyeFrameAt = 0L;
    private long lastDotFrameAt = 0L;
    private final Timer timer;
    private static final List<EyeWindow> WINDOWS = new CopyOnWriteArrayList<EyeWindow>();
    private static volatile BufferedImage EYE_IMG;
    private static volatile BufferedImage DOT_IMG;

    private static synchronized void ensureImagesLoaded() throws Exception {
        if (EYE_IMG == null) {
            EYE_IMG = EyeWindow.load(EYE_PATH);
        }
        if (DOT_IMG == null) {
            DOT_IMG = EyeWindow.load(DOT_PATH);
        }
    }

    private EyeWindow(BufferedImage eyeSheet, BufferedImage dotSheet) {
        this.eyeSheet = eyeSheet;
        this.dotSheet = dotSheet;
        this.eyeFrameW = eyeSheet.getWidth();
        this.eyeFrames = eyeSheet.getHeight() / eyeSheet.getWidth();
        this.eyeFrameH = eyeSheet.getHeight() / this.eyeFrames;
        this.dotFrameW = dotSheet.getWidth();
        this.dotFrames = dotSheet.getHeight() / dotSheet.getWidth();
        this.dotFrameH = dotSheet.getHeight() / this.dotFrames;
        this.setUndecorated(true);
        this.setResizable(false);
        this.setType(Window.Type.NORMAL);
        this.setAlwaysOnTop(true);
        this.setBackground(Color.BLACK);
        this.setSize(this.eyeFrameW, this.eyeFrameH);
        this.placeRandomly();
        this.setDefaultCloseOperation(2);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                EyeWindow.this.disposeAndMarkClosed();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                EyeWindow.this.disposeAndMarkClosed();
            }
        });
        this.setContentPane(new EyePanel());
        int delay = Math.max(1, 16);
        this.timer = new Timer(delay, e -> {
            long now = System.currentTimeMillis();
            if (now - this.lastEyeFrameAt >= 100L) {
                this.eyeFrameIndex = (this.eyeFrameIndex + 1) % this.eyeFrames;
                this.lastEyeFrameAt = now;
            }
            if (now - this.lastDotFrameAt >= 150L) {
                this.dotFrameIndex = (this.dotFrameIndex + 1) % this.dotFrames;
                this.lastDotFrameAt = now;
            }
            this.repaint();
        });
        this.getRootPane().registerKeyboardAction(e -> this.disposeAndMarkClosed(), KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void disposeAndMarkClosed() {
        try {
            this.timer.stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setVisible(false);
        this.dispose();
        WINDOWS.remove(this);
    }

    private static void createAndShowOne() throws Exception {
        EyeWindow w = new EyeWindow(EYE_IMG, DOT_IMG);
        WINDOWS.add(w);
        w.setVisible(true);
        w.toFront();
        w.requestFocus();
    }

    private void placeRandomly() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = ge.getScreenDevices();
        GraphicsDevice dev = devices[ThreadLocalRandom.current().nextInt(devices.length)];
        GraphicsConfiguration gc = dev.getDefaultConfiguration();
        Rectangle b = gc.getBounds();
        Insets in = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        int usableX = b.x + in.left;
        int usableY = b.y + in.top;
        int usableW = b.width - in.left - in.right;
        int usableH = b.height - in.top - in.bottom;
        int xMax = Math.max(1, usableW - this.getWidth());
        int yMax = Math.max(1, usableH - this.getHeight());
        int x = usableX + ThreadLocalRandom.current().nextInt(xMax);
        int y = usableY + ThreadLocalRandom.current().nextInt(yMax);
        this.setLocation(x, y);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.timer.start();
            new Timer(80, new ActionListener(){
                int n = 0;

                @Override
                public void actionPerformed(ActionEvent e) {
                    EyeWindow.this.toFront();
                    EyeWindow.this.requestFocus();
                    if (++this.n >= 5) {
                        ((Timer)e.getSource()).stop();
                    }
                }
            }){
                {
                    this.setRepeats(true);
                    this.start();
                }
            };
        }
    }

    public static void eyeStart(int count) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.getWindow().isFullscreen()) {
            mc.getWindow().toggleFullScreen();
        }
        int n = Math.max(1, Math.min(count, 32));
        Runnable job = () -> {
            try {
                EyeWindow.ensureImagesLoaded();
                for (int i = 0; i < n; ++i) {
                    EyeWindow.createAndShowOne();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        };
        if (EventQueue.isDispatchThread()) {
            job.run();
        } else {
            EventQueue.invokeLater(job);
        }
    }

    private static BufferedImage load(String path) throws Exception {
        InputStream in = EyeWindow.class.getResourceAsStream(path);
        if (in == null) {
            throw new IllegalStateException("Resource not found on classpath: " + path);
        }
        try (InputStream inputStream = in;){
            BufferedImage bufferedImage = ImageIO.read(in);
            return bufferedImage;
        }
    }

    private final class EyePanel
    extends JPanel {
        EyePanel() {
            this.setOpaque(true);
            this.setBackground(Color.BLACK);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                int sy1 = EyeWindow.this.eyeFrameIndex * EyeWindow.this.eyeFrameH;
                g2.drawImage(EyeWindow.this.eyeSheet, 0, 0, EyeWindow.this.eyeFrameW, EyeWindow.this.eyeFrameH, 0, sy1, EyeWindow.this.eyeFrameW, sy1 + EyeWindow.this.eyeFrameH, null);
                Point winOnScreen = this.getLocationOnScreenSafe();
                int cx = winOnScreen.x + this.getWidth() / 2;
                int cy = winOnScreen.y + this.getHeight() / 2;
                Point mouse = this.getGlobalMouse();
                int dx = mouse.x - cx;
                int dy = mouse.y - cy;
                double maxRadius = (double)Math.min(this.getWidth(), this.getHeight()) * 0.12;
                double dist = Math.hypot(dx, dy);
                double k = dist > 1.0E-6 ? Math.min(1.0, maxRadius / dist) : 0.0;
                int localX = (int)Math.round((double)this.getWidth() / 2.0 + (double)dx * k);
                int localY = (int)Math.round((double)this.getHeight() / 2.0 + (double)dy * k);
                int dotSy1 = EyeWindow.this.dotFrameIndex * EyeWindow.this.dotFrameH;
                int drawX = localX - EyeWindow.this.dotFrameW / 2;
                int drawY = localY - EyeWindow.this.dotFrameH / 2;
                g2.drawImage(EyeWindow.this.dotSheet, drawX, drawY, drawX + EyeWindow.this.dotFrameW, drawY + EyeWindow.this.dotFrameH, 0, dotSy1, EyeWindow.this.dotFrameW, dotSy1 + EyeWindow.this.dotFrameH, null);
            }
            finally {
                g2.dispose();
            }
        }

        private Point getGlobalMouse() {
            try {
                PointerInfo pi = MouseInfo.getPointerInfo();
                if (pi != null && pi.getLocation() != null) {
                    return pi.getLocation();
                }
            }
            catch (Throwable pi) {
                // empty catch block
            }
            Point p = this.getLocationOnScreenSafe();
            return new Point(p.x + this.getWidth() / 2, p.y + this.getHeight() / 2);
        }

        private Point getLocationOnScreenSafe() {
            try {
                return EyeWindow.this.getLocationOnScreen();
            }
            catch (IllegalComponentStateException ex) {
                return EyeWindow.this.getLocation();
            }
        }
    }
}

