#version 150
uniform sampler2D DiffuseSampler;
uniform sampler2D DepthSampler;
uniform vec4 ColorModulate;
uniform float Time;

in vec2 texCoord;
out vec4 fragColor;

void main() {
    // --- Ограничение частоты обновления кадра ---
    float targetFPS = 24.0;               // "визуальный FPS"
    float framePeriod = 1.0 / targetFPS;
    float frozenTime = floor(Time / framePeriod) * framePeriod;

    // --- Глубина для пикселизации ---
    float depth = texture(DepthSampler, texCoord).r;
    float t = smoothstep(0.8, 0.9, depth);
    float resFactor = mix(3.5, 1.0, t);

    // --- Базовое "низкое" разрешение ---
    vec2 baseRes = vec2(320.0, 180.0);
    vec2 res = baseRes * resFactor;
    vec2 uv = floor(texCoord * res) / res;

    // --- Цветовое смещение (без дрожания) ---
    float chromaShift = 0.00012;
    float r = texture(DiffuseSampler, uv + vec2(chromaShift, 0.0)).r;
    float g = texture(DiffuseSampler, uv).g;
    float b = texture(DiffuseSampler, uv - vec2(chromaShift, 0.0)).b;
    vec3 color = vec3(r, g, b);

    // --- Постеризация цвета ---
    color = floor(color * 20.0) / 20.0;

    float lineSpeed = 0.01;
    float line = sin((texCoord.y + frozenTime * lineSpeed) * 1000.0) * 0.02;
    color.rgb -= line;

    // --- Статичный шум VHS ---
    float noise = fract(sin(dot(texCoord * 2000.0, vec2(12.9898,78.233))) * 43758.5453);
    color += (noise - 0.5) * 0.01;

    fragColor = vec4(color, 1.0) * ColorModulate;
}
