#version 150

in vec4 Position;

uniform mat4 ProjMat;
uniform vec2 OutSize; // размер кадра (px)

out vec2 texCoord;

void main() {
    // стандартная позиция для полноэкранного квадрата
    vec4 outPos = ProjMat * vec4(Position.xy, 0.0, 1.0);

    // "дрожание" геометрии, имитирующее неточный float PS1
    float jitter = 1.0 / 160.0; // сила сдвига
    outPos.xy += fract(sin(outPos.xy * 43758.5453) * 100.0) * jitter - jitter * 0.5;

    gl_Position = vec4(outPos.xy, 0.0, 1.0);

    // Квантование координат — как будто 320x240
    vec2 pixelSize = 1.0 / (OutSize / 2.0);
    texCoord = floor(Position.xy / (pixelSize * 2.0)) * (pixelSize * 2.0) / OutSize;
}
