/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tieable.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public class ConfigLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LogUtils.getLogger();

    public static <T> T load(Class<T> clazz, String path, T defaultValue) {
        try {
            FileInputStream stream = new FileInputStream(path);
            InputStreamReader reader = new InputStreamReader(stream);
            return (T)GSON.fromJson((Reader)reader, clazz);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Failed to load config", (Throwable)e);
            ConfigLoader.save(path, defaultValue);
            return defaultValue;
        }
    }

    public static <T> void save(String path, T value) {
        try {
            FileUtils.write((File)new File(path), (CharSequence)GSON.toJson(value), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save config", (Throwable)e);
        }
    }
}

