/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tieable.item;

import com.iafenvoy.tieable.config.TieableConfig;
import com.iafenvoy.tieable.item.component.TieComponent;
import com.iafenvoy.tieable.registry.TieableBlockEntities;
import com.iafenvoy.tieable.registry.TieableBlocks;
import com.iafenvoy.tieable.registry.tag.TieableItemTags;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TiedBlockItem
extends BlockItem {
    private static final Map<Property<?>, ItemLike> PROPERTY_BLOCK_MAP = new HashMap();

    public TiedBlockItem(Block block, Item.Properties settings) {
        super(block, settings);
    }

    public boolean m_142305_(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        if (TieableConfig.INSTANCE.shearsUntieOnItems && clickType == ClickAction.SECONDARY && slot.m_150651_(player) && otherStack.m_204117_(TieableItemTags.CUT_ROPE)) {
            otherStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
            ItemStack split = stack.m_41620_(1);
            TieComponent component = TiedBlockItem.readStoredBlock(split);
            player.m_150109_().m_150079_(new ItemStack((ItemLike)component.storedBlock(), 8));
            player.m_150109_().m_150079_(new ItemStack((ItemLike)component.rope()));
            return true;
        }
        return false;
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag options) {
        super.m_7373_(stack, world, tooltip, options);
        TieComponent component = TiedBlockItem.readStoredBlock(stack);
        tooltip.add((Component)Component.m_237110_((String)"item.tieable.tied.tooltip", (Object[])new Object[]{Component.m_237115_((String)component.storedBlock().m_7705_())}));
    }

    public static void register(Property<?> property, ItemLike item) {
        PROPERTY_BLOCK_MAP.put(property, item);
    }

    public static ItemStack createStack(TieComponent data) {
        BlockState state = data.storedBlock().m_49966_();
        ItemLike target = PROPERTY_BLOCK_MAP.entrySet().stream().filter(p -> state.m_61138_((Property)p.getKey())).findFirst().map(Map.Entry::getValue).orElse((ItemLike)TieableBlocks.TIED.get());
        return TiedBlockItem.writeDataToStack(new ItemStack(target), data);
    }

    public static ItemStack writeDataToStack(ItemStack stack, TieComponent data) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("stored_block", BuiltInRegistries.f_256975_.m_7981_((Object)data.storedBlock()).toString());
        nbt.m_128359_("rope", BuiltInRegistries.f_257033_.m_7981_((Object)data.rope()).toString());
        TiedBlockItem.m_186338_((ItemStack)stack, (BlockEntityType)((BlockEntityType)TieableBlockEntities.TIED.get()), (CompoundTag)nbt);
        return stack;
    }

    public static TieComponent readStoredBlock(ItemStack stack) {
        CompoundTag nbt = TiedBlockItem.m_186336_((ItemStack)stack);
        if (nbt == null) {
            return new TieComponent(Blocks.f_50016_, Items.f_41852_);
        }
        Block storedBlock = (Block)BuiltInRegistries.f_256975_.m_7745_(ResourceLocation.m_135820_((String)nbt.m_128461_("stored_block")));
        Item rope = (Item)BuiltInRegistries.f_257033_.m_7745_(ResourceLocation.m_135820_((String)nbt.m_128461_("rope")));
        return new TieComponent(storedBlock, rope);
    }
}

