/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tieable.render;

import com.iafenvoy.tieable.item.TiedBlockItem;
import com.iafenvoy.tieable.item.block.entity.TiedBlockEntity;
import com.iafenvoy.tieable.render.DynamicItemRenderer;
import com.iafenvoy.tieable.render.model.CubeModel;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TiedBlockRenderer
implements BlockEntityRenderer<TiedBlockEntity>,
DynamicItemRenderer {
    private static final ResourceLocation BASE_TEXTURE = ResourceLocation.m_214293_((String)"tieable", (String)"textures/entity/tied.png");
    private static final Vec3[] LOWER_OFFSETS = new Vec3[]{new Vec3(0.0, 0.0, 0.0), new Vec3(1.0, 0.0, 0.0), new Vec3(0.0, 0.0, 1.0), new Vec3(1.0, 0.0, 1.0)};
    private static final Vec3[] UPPER_OFFSETS = new Vec3[]{new Vec3(0.0, 1.0, 0.0), new Vec3(1.0, 1.0, 0.0), new Vec3(0.0, 1.0, 1.0), new Vec3(1.0, 1.0, 1.0)};
    private final Minecraft client = Minecraft.m_91087_();
    private final CubeModel model = new CubeModel(CubeModel.getTexturedModelData().m_171564_());

    private static <T extends Comparable<T>> BlockState copyProperty(Property<T> property, BlockState from, BlockState to) {
        return (BlockState)to.m_263224_(property, from.m_61143_(property));
    }

    public void render(TiedBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        matrices.m_85836_();
        BlockState state = entity.m_58900_();
        this.render(state.m_61147_().stream().reduce(entity.getStoredBlock().m_49966_(), (p, c) -> TiedBlockRenderer.copyProperty(c, state, p), (a, b) -> a), entity.m_58899_(), matrices, vertexConsumers, light, overlay);
        matrices.m_85849_();
    }

    @Override
    public void render(ItemStack stack, ItemDisplayContext mode, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (this.client.f_91075_ != null) {
            this.render(TiedBlockItem.readStoredBlock(stack).storedBlock().m_49966_(), this.client.f_91075_.m_20183_(), matrices, vertexConsumers, light, overlay);
        }
    }

    private void render(BlockState state, BlockPos pos, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        matrices.m_85836_();
        this.renderBlock(matrices, vertexConsumers, light, overlay);
        matrices.m_85841_(0.5f, 0.5f, 0.5f);
        BlockState upper = state.m_61138_((Property)BlockStateProperties.f_61401_) ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.UPPER) : state;
        for (Vec3 offset : LOWER_OFFSETS) {
            this.renderSingle(state, pos, offset, matrices, vertexConsumers);
        }
        for (Vec3 offset : UPPER_OFFSETS) {
            this.renderSingle(upper, pos, offset, matrices, vertexConsumers);
        }
        matrices.m_85849_();
    }

    private void renderBlock(PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        matrices.m_85836_();
        this.model.m_7695_(matrices, vertexConsumers.m_6299_(RenderType.m_110452_((ResourceLocation)BASE_TEXTURE)), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrices.m_85849_();
    }

    private void renderSingle(BlockState state, BlockPos pos, Vec3 offset, PoseStack matrices, MultiBufferSource vertexConsumers) {
        EntityBlock provider;
        BlockEntity blockEntity;
        matrices.m_85836_();
        float f = 5.0E-4f;
        matrices.m_85837_(offset.f_82479_ + (double)f, offset.f_82480_ + (double)f, offset.f_82481_ + (double)f);
        matrices.m_85841_(1.0f - f * 2.0f, 1.0f - f * 2.0f, 1.0f - f * 2.0f);
        this.client.m_91289_().m_110912_(state, matrices, vertexConsumers, 0xFFFFFF, OverlayTexture.f_118083_);
        Block block = state.m_60734_();
        if (block instanceof EntityBlock && (blockEntity = (provider = (EntityBlock)block).m_142194_(pos, state)) != null) {
            blockEntity.m_142339_((Level)this.client.f_91073_);
            this.client.m_167982_().m_112267_(blockEntity, 1.0f, matrices, vertexConsumers);
        }
        matrices.m_85849_();
    }
}

