/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tieable.item;

import com.iafenvoy.tieable.config.TieableConfig;
import com.iafenvoy.tieable.item.component.TieComponent;
import com.iafenvoy.tieable.registry.TieableBlocks;
import com.iafenvoy.tieable.registry.TieableDataComponents;
import com.iafenvoy.tieable.registry.tag.TieableItemTags;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TiedBlockItem
extends BlockItem {
    private static final Map<Property<?>, ItemLike> PROPERTY_BLOCK_MAP = new HashMap();

    public TiedBlockItem(Block block, Item.Properties settings) {
        super(block, settings);
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        if (TieableConfig.INSTANCE.shearsUntieOnItems && clickType == ClickAction.SECONDARY && slot.allowModification(player) && otherStack.is(TieableItemTags.CUT_ROPE)) {
            otherStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            ItemStack split = stack.split(1);
            TieComponent component = TiedBlockItem.readStoredBlock(split);
            player.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)component.storedBlock(), 8));
            player.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)component.rope()));
            return true;
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        TieComponent component = TiedBlockItem.readStoredBlock(stack);
        tooltip.add((Component)Component.translatable((String)"item.tieable.tied.tooltip", (Object[])new Object[]{Component.translatable((String)component.storedBlock().getDescriptionId())}));
    }

    public static void register(Property<?> property, ItemLike item) {
        PROPERTY_BLOCK_MAP.put(property, item);
    }

    public static ItemStack createStack(TieComponent data) {
        BlockState state = data.storedBlock().defaultBlockState();
        ItemLike target = PROPERTY_BLOCK_MAP.entrySet().stream().filter(p -> state.hasProperty((Property)p.getKey())).findFirst().map(Map.Entry::getValue).orElse((ItemLike)TieableBlocks.TIED.get());
        return TiedBlockItem.writeDataToStack(new ItemStack(target), data);
    }

    public static ItemStack writeDataToStack(ItemStack stack, TieComponent data) {
        stack.set((DataComponentType)TieableDataComponents.TIE.get(), (Object)data);
        return stack;
    }

    public static TieComponent readStoredBlock(ItemStack stack) {
        TieComponent component = (TieComponent)stack.get((DataComponentType)TieableDataComponents.TIE.get());
        return component != null ? component : new TieComponent(Blocks.AIR, Items.AIR);
    }
}

