/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tieable.item.block;

import com.iafenvoy.tieable.config.TieableConfig;
import com.iafenvoy.tieable.item.TiedBlockItem;
import com.iafenvoy.tieable.item.block.entity.TiedBlockEntity;
import com.iafenvoy.tieable.item.component.TieComponent;
import com.iafenvoy.tieable.registry.TieableBlocks;
import com.iafenvoy.tieable.registry.TieableDataComponents;
import com.iafenvoy.tieable.registry.tag.TieableItemTags;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TiedBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final MapCodec<TiedBlock> CODEC = TiedBlock.simpleCodec(x -> new TiedBlock());

    public TiedBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIAMOND_BLOCK).instabreak());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (TieableConfig.INSTANCE.shearsUntieOnBlocks && player.getItemInHand(hand).is(TieableItemTags.CUT_ROPE) && (blockEntity = world.getBlockEntity(pos)) instanceof TiedBlockEntity) {
            TiedBlockEntity tied = (TiedBlockEntity)blockEntity;
            TiedBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)tied.getStoredBlock().asItem(), 8));
            TiedBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.LEAD));
            if (!world.isClientSide) {
                world.destroyBlock(pos, false);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, world, pos, player, hand, hit);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.setPlacedBy(world, pos, state, placer, itemStack);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof TiedBlockEntity) {
            TiedBlockEntity tied = (TiedBlockEntity)blockEntity;
            TieComponent component = TiedBlockItem.readStoredBlock(itemStack);
            tied.setStoredBlock(component.storedBlock());
            tied.setRope(component.rope());
        }
    }

    public void playerDestroy(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.playerDestroy(world, player, pos, state, blockEntity, tool);
        if (blockEntity instanceof TiedBlockEntity) {
            TiedBlockEntity tied = (TiedBlockEntity)blockEntity;
            ItemStack stack = new ItemStack((ItemLike)TieableBlocks.TIED.get());
            tied.saveToItem(stack, (HolderLookup.Provider)world.registryAccess());
            TiedBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)stack);
        }
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter world, BlockPos pos) {
        return TiedBlock.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        ItemStack stack = super.getCloneItemStack(world, pos, state);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof TiedBlockEntity) {
            TiedBlockEntity tied = (TiedBlockEntity)blockEntity;
            stack.set((DataComponentType)TieableDataComponents.TIE.get(), (Object)new TieComponent(tied.getStoredBlock(), tied.getRope()));
        }
        return stack;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TiedBlockEntity(pos, state);
    }

    public boolean canPlaceLiquid(Player player, BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        TiedBlockEntity tied;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity instanceof TiedBlockEntity && (tied = (TiedBlockEntity)blockEntity).getStoredBlock().defaultBlockState().hasProperty((Property)WATERLOGGED) && super.canPlaceLiquid(player, world, pos, state, fluid);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

