/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tieable.item.block.entity;

import com.iafenvoy.tieable.registry.TieableBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TiedBlockEntity
extends BlockEntity {
    public static final String STORED_BLOCK_KEY = "stored_block";
    public static final String ROPE_KEY = "rope";
    private Block storedBlock = Blocks.AIR;
    private Item rope = Items.AIR;

    public TiedBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TieableBlockEntities.TIED.get(), pos, state);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.setStoredBlock((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)nbt.getString(STORED_BLOCK_KEY))));
        this.setRope((Item)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)nbt.getString(ROPE_KEY))));
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putString(STORED_BLOCK_KEY, BuiltInRegistries.BLOCK.getKey((Object)this.getStoredBlock()).toString());
        nbt.putString(ROPE_KEY, BuiltInRegistries.ITEM.getKey((Object)this.getRope()).toString());
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        return this.saveWithoutMetadata(registryLookup);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public Block getStoredBlock() {
        return this.storedBlock;
    }

    public void setStoredBlock(Block storedBlock) {
        this.storedBlock = storedBlock;
    }

    public Item getRope() {
        return this.rope;
    }

    public void setRope(Item rope) {
        this.rope = rope;
    }
}

