/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tieable.recipe;

import com.iafenvoy.tieable.item.TiedBlockItem;
import com.iafenvoy.tieable.item.component.TieComponent;
import com.iafenvoy.tieable.registry.TieableBlocks;
import com.iafenvoy.tieable.registry.tag.TieableItemTags;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public enum TiedBlockRecipe implements CraftingRecipe
{
    INSTANCE;


    public boolean matches(CraftingInput inventory, Level world) {
        if (!this.canCraftInDimensions(inventory.width(), inventory.height())) {
            return false;
        }
        ItemStack stack = inventory.getItem(0);
        if (!stack.isEmpty() && stack.getItem() instanceof BlockItem) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    ItemStack inInv = inventory.getItem(i * 3 + j);
                    if (!(i == 1 && j == 1 ? !inInv.is(TieableItemTags.ROPE) : !inInv.is(stack.getItem()))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public ItemStack craft(CraftingInput inventory, HolderLookup.Provider registryManager) {
        if (!this.canCraftInDimensions(inventory.width(), inventory.height())) {
            return ItemStack.EMPTY;
        }
        ItemStack stored = inventory.getItem(0);
        ItemStack rope = inventory.getItem(4);
        Item item = stored.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return TiedBlockItem.createStack(new TieComponent(blockItem.getBlock(), rope.getItem()));
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width == 3 && height == 3;
    }

    @Deprecated
    public ItemStack getResultItem(HolderLookup.Provider registryManager) {
        return new ItemStack((ItemLike)TieableBlocks.TIED.get());
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.BUILDING;
    }

    public static enum Serializer implements RecipeSerializer<TiedBlockRecipe>
    {
        INSTANCE;


        public MapCodec<TiedBlockRecipe> codec() {
            return MapCodec.unit((Object)((Object)INSTANCE));
        }

        public StreamCodec<RegistryFriendlyByteBuf, TiedBlockRecipe> streamCodec() {
            return StreamCodec.unit((Object)((Object)INSTANCE));
        }
    }
}

