/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tieable.render;

import com.iafenvoy.tieable.item.TiedBlockItem;
import com.iafenvoy.tieable.item.block.entity.TiedBlockEntity;
import com.iafenvoy.tieable.render.DynamicItemRenderer;
import com.iafenvoy.tieable.render.model.CubeModel;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TiedBlockRenderer
implements BlockEntityRenderer<TiedBlockEntity>,
DynamicItemRenderer {
    private static final ResourceLocation BASE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"tieable", (String)"textures/entity/tied.png");
    private static final Vec3[] LOWER_OFFSETS = new Vec3[]{new Vec3(0.0, 0.0, 0.0), new Vec3(1.0, 0.0, 0.0), new Vec3(0.0, 0.0, 1.0), new Vec3(1.0, 0.0, 1.0)};
    private static final Vec3[] UPPER_OFFSETS = new Vec3[]{new Vec3(0.0, 1.0, 0.0), new Vec3(1.0, 1.0, 0.0), new Vec3(0.0, 1.0, 1.0), new Vec3(1.0, 1.0, 1.0)};
    private final Minecraft client = Minecraft.getInstance();
    private final CubeModel model = new CubeModel(CubeModel.getTexturedModelData().bakeRoot());

    private static <T extends Comparable<T>> BlockState copyProperty(Property<T> property, BlockState from, BlockState to) {
        return (BlockState)to.trySetValue(property, from.getValue(property));
    }

    public void render(TiedBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        matrices.pushPose();
        BlockState state = entity.getBlockState();
        this.render(state.getProperties().stream().reduce(entity.getStoredBlock().defaultBlockState(), (p, c) -> TiedBlockRenderer.copyProperty(c, state, p), (a, b) -> a), entity.getBlockPos(), matrices, vertexConsumers, light, overlay);
        matrices.popPose();
    }

    @Override
    public void render(ItemStack stack, ItemDisplayContext mode, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (this.client.cameraEntity != null) {
            this.render(TiedBlockItem.readStoredBlock(stack).storedBlock().defaultBlockState(), this.client.cameraEntity.blockPosition(), matrices, vertexConsumers, 0xF000F0, overlay);
        }
    }

    private void render(BlockState state, BlockPos pos, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        matrices.pushPose();
        this.renderBlock(matrices, vertexConsumers, light, overlay);
        matrices.scale(0.5f, 0.5f, 0.5f);
        BlockState upper = state.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) ? (BlockState)state.setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER) : state;
        for (Vec3 offset : LOWER_OFFSETS) {
            this.renderSingle(state, pos, offset, matrices, vertexConsumers);
        }
        for (Vec3 offset : UPPER_OFFSETS) {
            this.renderSingle(upper, pos, offset, matrices, vertexConsumers);
        }
        matrices.popPose();
    }

    private void renderBlock(PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        matrices.pushPose();
        this.model.renderToBuffer(matrices, vertexConsumers.getBuffer(RenderType.entityCutout((ResourceLocation)BASE_TEXTURE)), light, overlay, -1);
        matrices.popPose();
    }

    private void renderSingle(BlockState state, BlockPos pos, Vec3 offset, PoseStack matrices, MultiBufferSource vertexConsumers) {
        EntityBlock provider;
        BlockEntity blockEntity;
        matrices.pushPose();
        float f = 5.0E-4f;
        matrices.translate(offset.x + (double)f, offset.y + (double)f, offset.z + (double)f);
        matrices.scale(1.0f - f * 2.0f, 1.0f - f * 2.0f, 1.0f - f * 2.0f);
        this.client.getBlockRenderer().renderSingleBlock(state, matrices, vertexConsumers, 0xFFFFFF, OverlayTexture.NO_OVERLAY);
        Block block = state.getBlock();
        if (block instanceof EntityBlock && (blockEntity = (provider = (EntityBlock)block).newBlockEntity(pos, state)) != null) {
            blockEntity.setLevel((Level)this.client.level);
            this.client.getBlockEntityRenderDispatcher().render(blockEntity, 1.0f, matrices, vertexConsumers);
        }
        matrices.popPose();
    }
}

