package io.wispforest.owo.mixin.neoforge;

import io.wispforest.owo.network.OwoHandshake;
import io.wispforest.owo.network.OwoNetChannel;
import net.minecraft.client.Minecraft;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.registration.NetworkRegistry;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Set;

@Mixin(OwoNetChannel.class)
public abstract class OwoNetChannelClientMixin {
    @Shadow
    @Final
    private boolean required;

    @Shadow
    protected static Set<ResourceLocation> getChannelSet(Connection connection) {
        return null;
    }

    @Shadow
    @Final
    private CustomPacketPayload.Type<OwoNetChannel.MessagePayload> packetId;

    @Inject(method = "canSendToServer", at = @At("HEAD"), cancellable = true)
    private void checkIfCanSend(CallbackInfoReturnable<Boolean> cir) {
        if (required) {
            cir.setReturnValue(true);
        } else {
            cir.setReturnValue(
                OwoHandshake.isValidClient() ?
                    getChannelSet(Minecraft.getInstance().getConnection().getConnection()).contains(this.packetId.id())
                    : NetworkRegistry.hasChannel(Minecraft.getInstance().getConnection(), this.packetId.id())
            );
        }
    }
}
