/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.itemgroup;

import io.wispforest.owo.client.texture.AnimatedTextureDrawable;
import io.wispforest.owo.client.texture.SpriteSheetMetadata;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@FunctionalInterface
public interface Icon {
    public void render(GuiGraphics var1, int var2, int var3, int var4, int var5, float var6);

    public static Icon of(final ItemStack stack) {
        return new Icon(){

            @Override
            public void render(GuiGraphics context, int x, int y, int mouseX, int mouseY, float delta) {
                context.renderFakeItem(stack, x, y);
            }
        };
    }

    public static Icon of(ItemLike item) {
        return Icon.of(new ItemStack(item));
    }

    public static Icon of(final ResourceLocation texture, final int u, final int v, final int textureWidth, final int textureHeight) {
        return new Icon(){

            @Override
            public void render(GuiGraphics context, int x, int y, int mouseX, int mouseY, float delta) {
                context.blit(RenderPipelines.GUI_TEXTURED, texture, x, y, (float)u, (float)v, 16, 16, textureWidth, textureHeight);
            }
        };
    }

    public static Icon of(ResourceLocation texture, int textureSize, int frameDelay, boolean loop) {
        final AnimatedTextureDrawable widget = new AnimatedTextureDrawable(0, 0, 16, 16, texture, new SpriteSheetMetadata(textureSize, 16), frameDelay, loop);
        return new Icon(){

            @Override
            public void render(GuiGraphics context, int x, int y, int mouseX, int mouseY, float delta) {
                widget.render(x, y, context, mouseX, mouseY, delta);
            }
        };
    }
}

