/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.mixin.itemgroup;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import io.wispforest.owo.itemgroup.OwoItemGroup;
import io.wispforest.owo.itemgroup.gui.ItemGroupButton;
import io.wispforest.owo.itemgroup.gui.ItemGroupButtonWidget;
import io.wispforest.owo.itemgroup.gui.ItemGroupTab;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.util.CursorAdapter;
import io.wispforest.owo.util.pond.OwoCreativeInventoryScreenExtensions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTab;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CreativeModeInventoryScreen.class})
public abstract class CreativeInventoryScreenMixin
extends AbstractContainerScreen<CreativeModeInventoryScreen.ItemPickerMenu>
implements OwoCreativeInventoryScreenExtensions {
    @Shadow
    private static CreativeModeTab selectedTab;
    @Unique
    private final List<ItemGroupButtonWidget> owoButtons = new ArrayList<ItemGroupButtonWidget>();
    @Unique
    private FeatureFlagSet enabledFeatures = null;
    @Unique
    private final CursorAdapter cursorAdapter = CursorAdapter.ofClientWindow();

    @Shadow
    protected abstract void init();

    @Shadow
    protected abstract boolean hasPermissions(Player var1);

    @Shadow
    protected abstract boolean canScroll();

    @Inject(method={"<init>(Lnet/minecraft/client/player/LocalPlayer;Lnet/minecraft/world/flag/FeatureFlagSet;Z)V"}, at={@At(value="TAIL")})
    private void captureFeatures(LocalPlayer player, FeatureFlagSet enabledFeatures, boolean operatorTabEnabled, CallbackInfo ci) {
        this.enabledFeatures = enabledFeatures;
    }

    @ModifyArg(method={"renderBg(Lnet/minecraft/client/gui/GuiGraphics;FII)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blit(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIFFIIII)V", ordinal=0))
    private ResourceLocation injectCustomGroupTexture(ResourceLocation original) {
        OwoItemGroup owoGroup;
        CreativeModeTab creativeModeTab = selectedTab;
        if (!(creativeModeTab instanceof OwoItemGroup) || (owoGroup = (OwoItemGroup)creativeModeTab).getOwoBackgroundTexture() == null) {
            return original;
        }
        return owoGroup.getOwoBackgroundTexture();
    }

    @ModifyArg(method={"renderBg(Lnet/minecraft/client/gui/GuiGraphics;FII)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIII)V"))
    private ResourceLocation injectCustomScrollbarTexture(ResourceLocation texture) {
        OwoItemGroup owoGroup;
        CreativeModeTab creativeModeTab = selectedTab;
        if (!(creativeModeTab instanceof OwoItemGroup) || (owoGroup = (OwoItemGroup)creativeModeTab).getScrollerTextures() == null) {
            return texture;
        }
        return this.canScroll() ? owoGroup.getScrollerTextures().enabled() : owoGroup.getScrollerTextures().disabled();
    }

    @ModifyArg(method={"renderTabButton(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/item/CreativeModeTab;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIII)V"))
    private ResourceLocation injectCustomTabTexture(ResourceLocation texture, @Local(argsOnly=true) CreativeModeTab group) {
        OwoItemGroup contextGroup;
        if (!(group instanceof OwoItemGroup) || (contextGroup = (OwoItemGroup)group).getTabTextures() == null) {
            return texture;
        }
        OwoItemGroup.TabTextures textures = contextGroup.getTabTextures();
        return contextGroup.row() == CreativeModeTab.Row.TOP ? (selectedTab == contextGroup ? (contextGroup.column() == 0 ? textures.topSelectedFirstColumn() : textures.topSelected()) : textures.topUnselected()) : (selectedTab == contextGroup ? (contextGroup.column() == 0 ? textures.bottomSelectedFirstColumn() : textures.bottomSelected()) : textures.bottomUnselected());
    }

    @Inject(method={"renderTabButton(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/item/CreativeModeTab;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/CreativeModeTab;getIconItem()Lnet/minecraft/world/item/ItemStack;")})
    private void renderOwoIcon(GuiGraphics context, CreativeModeTab group, CallbackInfo ci, @Local(ordinal=3) int j, @Local(ordinal=4) int k) {
        if (!(group instanceof OwoItemGroup)) {
            return;
        }
        OwoItemGroup owoGroup = (OwoItemGroup)group;
        owoGroup.icon().render(context, j, k, 0, 0, 0.0f);
    }

    @ModifyArg(method={"renderLabels(Lnet/minecraft/client/gui/GuiGraphics;II)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;IIIZ)V"))
    private Component injectTabNameAsTitle(Component original) {
        OwoItemGroup owoGroup;
        CreativeModeTab creativeModeTab = selectedTab;
        if (!(creativeModeTab instanceof OwoItemGroup) || !(owoGroup = (OwoItemGroup)creativeModeTab).hasDynamicTitle() || owoGroup.selectedTabs().size() != 1) {
            return original;
        }
        ItemGroupTab singleActiveTab = owoGroup.getTab(owoGroup.selectedTabs().iterator().nextInt());
        if (singleActiveTab.primary()) {
            return singleActiveTab.name();
        }
        return Component.translatable((String)"text.owo.itemGroup.tab_template", (Object[])new Object[]{owoGroup.getDisplayName(), singleActiveTab.name()});
    }

    @Inject(at={@At(value="HEAD")}, method={"selectTab(Lnet/minecraft/world/item/CreativeModeTab;)V"})
    private void setSelectedTab(CreativeModeTab group, CallbackInfo ci) {
        this.owoButtons.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.owoButtons.clear();
        if (group instanceof OwoItemGroup) {
            OwoItemGroup owoGroup = (OwoItemGroup)group;
            int tabRootY = this.topPos;
            int tabStackHeight = owoGroup.getTabStackHeight();
            tabRootY -= 13 * (tabStackHeight - 4);
            if (owoGroup.shouldDisplaySingleTab() || owoGroup.tabs.size() > 1) {
                for (int tabIdx = 0; tabIdx < owoGroup.tabs.size(); ++tabIdx) {
                    ItemGroupTab tab = owoGroup.tabs.get(tabIdx);
                    int xOffset = this.leftPos - 27 - tabIdx / tabStackHeight * 26;
                    int yOffset = tabRootY + 10 + tabIdx % tabStackHeight * 30;
                    ItemGroupButtonWidget tabButton = new ItemGroupButtonWidget(xOffset, yOffset, 32, tab, this.owo$createSelectAction(owoGroup, tabIdx));
                    if (owoGroup.isTabSelected(tabIdx)) {
                        tabButton.isSelected = true;
                    }
                    this.owoButtons.add(tabButton);
                    this.addRenderableWidget((GuiEventListener)tabButton);
                }
            }
            int buttonStackHeight = owoGroup.getButtonStackHeight();
            tabRootY = this.topPos - 13 * (buttonStackHeight - 4);
            List<ItemGroupButton> buttons = owoGroup.getButtons();
            for (int i = 0; i < buttons.size(); ++i) {
                ItemGroupButton buttonDefinition = buttons.get(i);
                int xOffset = this.leftPos + 198 + i / buttonStackHeight * 26;
                int yOffset = tabRootY + 10 + i % buttonStackHeight * 30;
                ItemGroupButtonWidget tabButton = new ItemGroupButtonWidget(xOffset, yOffset, 0, buttonDefinition, __ -> buttonDefinition.action().run());
                this.owoButtons.add(tabButton);
                this.addRenderableWidget((GuiEventListener)tabButton);
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"})
    private void render(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        boolean anyButtonHovered = false;
        for (ItemGroupButtonWidget button : this.owoButtons) {
            if (!button.trulyHovered()) continue;
            context.setComponentTooltipForNextFrame(this.font, button.isTab() && ((OwoItemGroup)selectedTab).canSelectMultipleTabs() ? List.of(button.getMessage(), Component.translatable((String)"text.owo.itemGroup.select_hint")) : List.of(button.getMessage()), mouseX, mouseY, null);
            anyButtonHovered = true;
        }
        this.cursorAdapter.applyStyle(anyButtonHovered ? CursorStyle.HAND : CursorStyle.NONE);
    }

    @Inject(method={"removed()V"}, at={@At(value="HEAD")})
    private void disposeCursorAdapter(CallbackInfo ci) {
        this.cursorAdapter.dispose();
    }

    @Override
    public int owo$getRootX() {
        return this.leftPos;
    }

    @Override
    public int owo$getRootY() {
        return this.topPos;
    }

    @Unique
    private Consumer<ItemGroupButtonWidget> owo$createSelectAction(OwoItemGroup group, int tabIdx) {
        return button -> {
            boolean shift;
            CreativeModeTab.ItemDisplayParameters context = new CreativeModeTab.ItemDisplayParameters(this.enabledFeatures, this.hasPermissions(((CreativeModeInventoryScreen.ItemPickerMenu)this.menu).player()), (HolderLookup.Provider)((CreativeModeInventoryScreen.ItemPickerMenu)this.menu).player().level().registryAccess());
            boolean bl = shift = InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)340) || InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)344);
            if (shift) {
                group.toggleTab(tabIdx, context);
            } else {
                group.selectSingleTab(tabIdx, context);
            }
            this.rebuildWidgets();
            button.isSelected = true;
        };
    }

    public CreativeInventoryScreenMixin(CreativeModeInventoryScreen.ItemPickerMenu screenHandler, Inventory playerInventory, Component text) {
        super((AbstractContainerMenu)screenHandler, playerInventory, text);
    }
}

