/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.mixin.recipe_remainders;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import io.wispforest.owo.util.RecipeRemainderStorage;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ResultSlot.class})
public class CraftingResultSlotMixin {
    @Shadow
    @Final
    private Player player;

    @Inject(method={"onTake(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/CraftingContainer;setItem(ILnet/minecraft/world/item/ItemStack;)V", ordinal=1)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void fixRemainderStacking(Player player, ItemStack stack, CallbackInfo ci, CraftingInput.Positioned positioned, CraftingInput craftingRecipeInput, int i, int j, NonNullList defaultedList, int k, int l, int m, ItemStack itemStack, ItemStack remainderStack) {
        if (remainderStack.getCount() > remainderStack.getMaxStackSize()) {
            int excess = remainderStack.getCount() - remainderStack.getMaxStackSize();
            remainderStack.shrink(excess);
            ItemStack insertStack = remainderStack.copy();
            insertStack.setCount(excess);
            if (!this.player.getInventory().add(insertStack)) {
                this.player.drop(insertStack, false);
            }
        }
    }

    @WrapOperation(method={"getRemainingItems(Lnet/minecraft/world/item/crafting/CraftingInput;Lnet/minecraft/world/level/Level;)Lnet/minecraft/core/NonNullList;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/crafting/RecipeManager;getRecipeFor(Lnet/minecraft/world/item/crafting/RecipeType;Lnet/minecraft/world/item/crafting/RecipeInput;Lnet/minecraft/world/level/Level;)Ljava/util/Optional;")})
    private <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> captureRecipeEntry(RecipeManager instance, RecipeType<T> type, I input, Level world, Operation<Optional<RecipeHolder<T>>> original, @Share(value="owo_recipe_entry") LocalRef<Optional<RecipeHolder<T>>> recipeEntry) {
        Optional entry = (Optional)original.call(new Object[]{instance, type, input, world});
        recipeEntry.set((Object)entry);
        return entry;
    }

    @WrapOperation(method={"getRemainingItems(Lnet/minecraft/world/item/crafting/CraftingInput;Lnet/minecraft/world/level/Level;)Lnet/minecraft/core/NonNullList;"}, at={@At(value="INVOKE", target="Ljava/util/Optional;map(Ljava/util/function/Function;)Ljava/util/Optional;")})
    private <I extends RecipeInput, T extends Recipe<I>> Optional<NonNullList<ItemStack>> addRecipeSpecificRemainders(Optional<T> instance, Function<? super T, ? extends NonNullList<ItemStack>> mapper, Operation<Optional<NonNullList<ItemStack>>> original, @Share(value="owo_recipe_entry") LocalRef<Optional<RecipeHolder<?>>> recipeEntry, @Local(argsOnly=true) CraftingInput input) {
        Optional recipeEntryOptional = (Optional)recipeEntry.get();
        return ((Optional)original.call(new Object[]{instance, mapper})).map(defaultList -> {
            ResourceLocation recipeId = ((RecipeHolder)recipeEntryOptional.get()).id().location();
            if (RecipeRemainderStorage.has(recipeId)) {
                NonNullList remainders = defaultList;
                Map<Item, ItemStack> owoRemainders = RecipeRemainderStorage.get(recipeId);
                for (int i = 0; i < remainders.size(); ++i) {
                    Item item = input.getItem(i).getItem();
                    if (!owoRemainders.containsKey(item)) continue;
                    remainders.set(i, (Object)owoRemainders.get(item).copy());
                }
            }
            return defaultList;
        });
    }
}

