/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.mixin.ui;

import io.wispforest.owo.ui.component.DiscreteSliderComponent;
import io.wispforest.owo.ui.component.SliderComponent;
import io.wispforest.owo.ui.core.CursorStyle;
import java.math.BigDecimal;
import java.math.RoundingMode;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractSliderButton.class})
public abstract class SliderWidgetMixin
extends AbstractWidget {
    @Shadow
    protected double value;

    @Shadow
    protected abstract void setValue(double var1);

    public SliderWidgetMixin(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
    }

    @ModifyArg(method={"keyPressed(Lnet/minecraft/client/input/KeyEvent;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/AbstractSliderButton;setValue(D)V"))
    private double injectCustomStep(double value) {
        SliderWidgetMixin sliderWidgetMixin = this;
        if (!(sliderWidgetMixin instanceof SliderComponent)) {
            return value;
        }
        SliderComponent slider = (SliderComponent)((Object)sliderWidgetMixin);
        return this.value + Math.signum(value - this.value) * slider.scrollStep();
    }

    @Inject(method={"setValueFromMouse(Lnet/minecraft/client/input/MouseButtonEvent;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void makeItSnappyTeam(MouseButtonEvent click, CallbackInfo ci) {
        SliderWidgetMixin sliderWidgetMixin = this;
        if (!(sliderWidgetMixin instanceof DiscreteSliderComponent)) {
            return;
        }
        DiscreteSliderComponent discrete = (DiscreteSliderComponent)((Object)sliderWidgetMixin);
        if (!discrete.snap()) {
            return;
        }
        ci.cancel();
        double value = (click.x() - ((double)this.getX() + 4.0)) / ((double)this.width - 8.0);
        double min = discrete.min();
        double max = discrete.max();
        int decimalPlaces = discrete.decimalPlaces();
        this.setValue((new BigDecimal(min + value * (max - min)).setScale(decimalPlaces, RoundingMode.HALF_UP).doubleValue() - min) / (max - min));
    }

    protected CursorStyle owo$preferredCursorStyle() {
        return CursorStyle.MOVE;
    }
}

