/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.network.neoforge;

import io.wispforest.owo.client.screens.ScreenInternals;
import io.wispforest.owo.network.OwoHandshake;
import io.wispforest.owo.network.OwoNetChannel;
import io.wispforest.owo.network.neoforge.SidedPacketCodec;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class NeoOwoNetworking {
    public static final Map<CustomPacketPayload.Type<OwoNetChannel.MessagePayload>, SidedPacketCodec<OwoNetChannel.MessagePayload>> PAYLOAD_ID_TO_SIDED_CODEC = new HashMap<CustomPacketPayload.Type<OwoNetChannel.MessagePayload>, SidedPacketCodec<OwoNetChannel.MessagePayload>>();
    public static final Map<CustomPacketPayload.Type<?>, PayloadCodec<?>> PAYLOAD_ID_TO_CLIENT_CODEC = new HashMap();
    public static final Map<CustomPacketPayload.Type<?>, PayloadHandler<?>> PAYLOAD_ID_TO_CLIENT_HANDLER = new HashMap();
    public static final Map<CustomPacketPayload.Type<OwoNetChannel.MessagePayload>, PayloadHandler<OwoNetChannel.MessagePayload>> PAYLOAD_ID_TO_SERVER_PAYLOAD_HANDLER = new HashMap<CustomPacketPayload.Type<OwoNetChannel.MessagePayload>, PayloadHandler<OwoNetChannel.MessagePayload>>();
    public static final Map<CustomPacketPayload.Type<OwoNetChannel.MessagePayload>, PayloadHandler<OwoNetChannel.MessagePayload>> PAYLOAD_ID_TO_CLIENT_PAYLOAD_HANDLER = new HashMap<CustomPacketPayload.Type<OwoNetChannel.MessagePayload>, PayloadHandler<OwoNetChannel.MessagePayload>>();

    public static void onNetworkRegister(RegisterPayloadHandlersEvent event) {
        CustomPacketPayload.Type id;
        PayloadRegistrar registrar = event.registrar("1.0.0");
        for (Map.Entry<CustomPacketPayload.Type<?>, PayloadCodec<?>> entry : PAYLOAD_ID_TO_CLIENT_CODEC.entrySet()) {
            id = entry.getKey();
            PayloadHandler<?> handler = Objects.requireNonNull(PAYLOAD_ID_TO_CLIENT_HANDLER.get(id), "Unable to register the given client play packet due to missing the needed handler! Id: " + String.valueOf(id));
            entry.getValue().registerPlayPayload(registrar, handler);
        }
        OwoHandshake.register(registrar);
        ScreenInternals.init(registrar);
        registrar = registrar.optional();
        for (Map.Entry<Object, Record> entry : PAYLOAD_ID_TO_SIDED_CODEC.entrySet()) {
            id = (CustomPacketPayload.Type)entry.getKey();
            if (!PAYLOAD_ID_TO_SERVER_PAYLOAD_HANDLER.containsKey(id)) {
                throw new IllegalStateException("Unable to get the required Payload Handler as its missing for the Server! Id: " + String.valueOf(id));
            }
            if (!PAYLOAD_ID_TO_CLIENT_PAYLOAD_HANDLER.containsKey(id)) {
                throw new IllegalStateException("Unable to get the required Payload Handler as its missing for the Client! Id: " + String.valueOf(id));
            }
            IPayloadHandler biDiHandler = (arg, iPayloadContext) -> iPayloadContext.enqueueWork(() -> {
                Player player = iPayloadContext.player();
                PayloadHandler<OwoNetChannel.MessagePayload> handler = !player.level().isClientSide() ? PAYLOAD_ID_TO_SERVER_PAYLOAD_HANDLER.get(id) : PAYLOAD_ID_TO_CLIENT_PAYLOAD_HANDLER.get(id);
                handler.accept((OwoNetChannel.MessagePayload)arg, iPayloadContext.player());
            });
            registrar.playBidirectional(id, (StreamCodec)entry.getValue(), biDiHandler, biDiHandler);
        }
    }

    public static void registerMessageCodecs(CustomPacketPayload.Type<OwoNetChannel.MessagePayload> id, StreamCodec<FriendlyByteBuf, OwoNetChannel.MessagePayload> serverCodec, StreamCodec<FriendlyByteBuf, OwoNetChannel.MessagePayload> clientCodec) {
        if (PAYLOAD_ID_TO_SIDED_CODEC.containsKey(id)) {
            throw new IllegalStateException("Unable to register the given codec as such already exists within codec map! Id: " + String.valueOf(id));
        }
        PAYLOAD_ID_TO_SIDED_CODEC.put(id, new SidedPacketCodec<OwoNetChannel.MessagePayload>(serverCodec, clientCodec));
    }

    public static <T extends CustomPacketPayload> void registerClientCodec(CustomPacketPayload.Type<T> id, StreamCodec<FriendlyByteBuf, T> codec) {
        if (PAYLOAD_ID_TO_CLIENT_CODEC.containsKey(id)) {
            throw new IllegalStateException("Unable to register the given codec as such already exists within codec map! Id: " + String.valueOf(id));
        }
        PAYLOAD_ID_TO_CLIENT_CODEC.put(id, new PayloadCodec<T>(id, codec, Optional.of(PacketFlow.CLIENTBOUND)));
    }

    public static <T extends CustomPacketPayload> void registerClientPayload(CustomPacketPayload.Type<T> id, PayloadHandler<T> payloadHandler) {
        if (PAYLOAD_ID_TO_CLIENT_HANDLER.containsKey(id)) {
            throw new IllegalStateException("Unable to register the given codec as such already exists within codec map! Id: " + String.valueOf(id));
        }
        PAYLOAD_ID_TO_CLIENT_HANDLER.put(id, payloadHandler);
    }

    public static void registerServerMessageHandler(CustomPacketPayload.Type<OwoNetChannel.MessagePayload> id, PayloadHandler<OwoNetChannel.MessagePayload> handler) {
        if (PAYLOAD_ID_TO_SERVER_PAYLOAD_HANDLER.containsKey(id)) {
            throw new IllegalStateException("Unable to register the given server handler as such already exists within handler map! Id: " + String.valueOf(id));
        }
        PAYLOAD_ID_TO_SERVER_PAYLOAD_HANDLER.put(id, handler);
    }

    public static void registerClientMessageHandler(CustomPacketPayload.Type<OwoNetChannel.MessagePayload> id, PayloadHandler<OwoNetChannel.MessagePayload> handler) {
        if (PAYLOAD_ID_TO_CLIENT_PAYLOAD_HANDLER.containsKey(id)) {
            throw new IllegalStateException("Unable to register the given client handler as such already exists within handler map! Id: " + String.valueOf(id));
        }
        PAYLOAD_ID_TO_CLIENT_PAYLOAD_HANDLER.put(id, handler);
    }

    public static interface PayloadHandler<T extends CustomPacketPayload>
    extends BiConsumer<T, Player> {
        public static <P extends CustomPacketPayload> PayloadHandler<P> empty() {
            return (payload, player) -> {};
        }

        @Override
        public void accept(T var1, Player var2);
    }

    private record PayloadCodec<T extends CustomPacketPayload>(CustomPacketPayload.Type<T> id, StreamCodec<FriendlyByteBuf, T> codec, Optional<PacketFlow> possibleSide) {
        public void registerPlayPayload(PayloadRegistrar registrar, PayloadHandler<?> handler) {
            PayloadHandler<?> castedHandler = handler;
            this.possibleSide.ifPresentOrElse(side -> {
                if (side.isClientbound()) {
                    registrar.playToClient(this.id, this.codec, (arg, context) -> context.enqueueWork(() -> castedHandler.accept(arg, context.player())));
                } else {
                    registrar.playToServer(this.id, this.codec, (arg, context) -> context.enqueueWork(() -> castedHandler.accept(arg, context.player())));
                }
            }, () -> {
                IPayloadHandler biDiHandler = (arg, context) -> context.enqueueWork(() -> castedHandler.accept(arg, context.player()));
                registrar.playBidirectional(this.id, this.codec, biDiHandler, biDiHandler);
            });
        }
    }
}

