/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.core;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import io.wispforest.owo.mixin.ui.access.DrawContextAccessor;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIPipelines;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.event.WindowResizeCallback;
import io.wispforest.owo.ui.renderstate.CircleElementRenderState;
import io.wispforest.owo.ui.renderstate.GradientQuadElementRenderState;
import io.wispforest.owo.ui.renderstate.LineElementRenderState;
import io.wispforest.owo.ui.renderstate.RingElementRenderState;
import io.wispforest.owo.ui.util.NinePatchTexture;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public class OwoUIDrawContext
extends GuiGraphics {
    public static final ResourceLocation PANEL_NINE_PATCH_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"panel/default");
    public static final ResourceLocation DARK_PANEL_NINE_PATCH_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"panel/dark");
    public static final ResourceLocation PANEL_INSET_NINE_PATCH_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"panel/inset");
    private final Consumer<Runnable> setTooltipDrawer;

    private OwoUIDrawContext(Minecraft client, GuiRenderState renderState, Consumer<Runnable> setTooltipDrawer) {
        super(client, renderState);
        this.setTooltipDrawer = setTooltipDrawer;
    }

    public static OwoUIDrawContext of(GuiGraphics context) {
        OwoUIDrawContext owoContext = new OwoUIDrawContext(Minecraft.getInstance(), context.guiRenderState, ((DrawContextAccessor)context)::owo$setTooltipDrawer);
        ((DrawContextAccessor)((Object)owoContext)).owo$setScissorStack(((DrawContextAccessor)context).owo$getScissorStack());
        ((DrawContextAccessor)((Object)owoContext)).owo$setMatrices(((DrawContextAccessor)context).owo$getMatrices());
        return owoContext;
    }

    public static UtilityScreen utilityScreen() {
        return UtilityScreen.get();
    }

    public boolean intersectsScissor(PositionedRectangle other) {
        other = other.transform((Matrix3x2f)this.getMatrixStack());
        ScreenRectangle rect = this.scissorStack.peek();
        if (rect == null) {
            return true;
        }
        ScreenPosition pos = rect.position();
        return other.x() < pos.x() + rect.width() && other.x() + other.width() >= pos.x() && other.y() < pos.y() + rect.height() && other.y() + other.height() >= pos.y();
    }

    public void drawRectOutline(int x, int y, int width, int height, int color) {
        this.drawRectOutline(RenderPipelines.GUI, x, y, width, height, color);
    }

    public void drawRectOutline(RenderPipeline pipeline, int x, int y, int width, int height, int color) {
        this.fill(pipeline, x, y, x + width, y + 1, color);
        this.fill(pipeline, x, y + height - 1, x + width, y + height, color);
        this.fill(pipeline, x, y + 1, x + 1, y + height - 1, color);
        this.fill(pipeline, x + width - 1, y + 1, x + width, y + height - 1, color);
    }

    public void drawGradientRect(int x, int y, int width, int height, int topLeftColor, int topRightColor, int bottomRightColor, int bottomLeftColor) {
        this.drawGradientRect(RenderPipelines.GUI, x, y, width, height, topLeftColor, topRightColor, bottomRightColor, bottomLeftColor);
    }

    public void drawGradientRect(RenderPipeline pipeline, int x, int y, int width, int height, int topLeftColor, int topRightColor, int bottomRightColor, int bottomLeftColor) {
        this.guiRenderState.submitGuiElement((GuiElementRenderState)new GradientQuadElementRenderState(pipeline, new Matrix3x2f((Matrix3x2fc)this.pose()), new ScreenRectangle(new ScreenPosition(x, y), width, height), this.scissorStack.peek(), Color.ofArgb(topLeftColor), Color.ofArgb(topRightColor), Color.ofArgb(bottomLeftColor), Color.ofArgb(bottomRightColor)));
    }

    public void drawPanel(int x, int y, int width, int height, boolean dark) {
        NinePatchTexture.draw(dark ? DARK_PANEL_NINE_PATCH_TEXTURE : PANEL_NINE_PATCH_TEXTURE, this, x, y, width, height);
    }

    public void drawSpectrum(int x, int y, int width, int height, boolean vertical) {
        this.guiRenderState.submitGuiElement((GuiElementRenderState)new GradientQuadElementRenderState(OwoUIPipelines.GUI_HSV, new Matrix3x2f((Matrix3x2fc)this.pose()), new ScreenRectangle(new ScreenPosition(x, y), width, height), this.scissorStack.peek(), Color.WHITE, new Color(vertical ? 1.0f : 0.0f, 1.0f, 1.0f), new Color(vertical ? 0.0f : 1.0f, 1.0f, 1.0f), new Color(0.0f, 1.0f, 1.0f)));
    }

    public void drawText(net.minecraft.network.chat.Component text, float x, float y, float scale, int color) {
        this.drawText(text, x, y, scale, color, TextAnchor.TOP_LEFT);
    }

    public void drawText(net.minecraft.network.chat.Component text, float x, float y, float scale, int color, TextAnchor anchorPoint) {
        Font textRenderer = Minecraft.getInstance().font;
        this.pose().pushMatrix();
        this.pose().scale(scale, scale);
        switch (anchorPoint.ordinal()) {
            case 0: {
                x -= (float)textRenderer.width((FormattedText)text) * scale;
                break;
            }
            case 3: {
                Objects.requireNonNull(textRenderer);
                y -= 9.0f * scale;
                break;
            }
            case 1: {
                x -= (float)textRenderer.width((FormattedText)text) * scale;
                Objects.requireNonNull(textRenderer);
                y -= 9.0f * scale;
            }
        }
        this.drawString(textRenderer, text, (int)(x * (1.0f / scale)), (int)(y * (1.0f / scale)), color, false);
        this.pose().popMatrix();
    }

    public void drawLine(int x1, int y1, int x2, int y2, double thiccness, Color color) {
        this.drawLine(RenderPipelines.GUI, x1, y1, x2, y2, thiccness, color);
    }

    public void drawLine(RenderPipeline pipeline, int x1, int y1, int x2, int y2, double thiccness, Color color) {
        this.guiRenderState.submitGuiElement((GuiElementRenderState)new LineElementRenderState(pipeline, new Matrix3x2f((Matrix3x2fc)this.pose()), this.scissorStack.peek(), x1, y1, x2, y2, thiccness, color));
    }

    public void drawCircle(int centerX, int centerY, int segments, double radius, Color color) {
        this.drawCircle(OwoUIPipelines.GUI_TRIANGLE_FAN, centerX, centerY, segments, radius, color);
    }

    public void drawCircle(int centerX, int centerY, double angleFrom, double angleTo, int segments, double radius, Color color) {
        this.drawCircle(OwoUIPipelines.GUI_TRIANGLE_FAN, centerX, centerY, angleFrom, angleTo, segments, radius, color);
    }

    public void drawCircle(RenderPipeline pipeline, int centerX, int centerY, int segments, double radius, Color color) {
        this.drawCircle(pipeline, centerX, centerY, 0.0, 360.0, segments, radius, color);
    }

    public void drawCircle(RenderPipeline pipeline, int centerX, int centerY, double angleFrom, double angleTo, int segments, double radius, Color color) {
        Preconditions.checkArgument((angleFrom < angleTo ? 1 : 0) != 0, (Object)"angleFrom must be less than angleTo");
        this.guiRenderState.submitGuiElement((GuiElementRenderState)new CircleElementRenderState(pipeline, new Matrix3x2f((Matrix3x2fc)this.pose()), this.scissorStack.peek(), centerX, centerY, angleFrom, angleTo, segments, radius, color));
    }

    public void drawRing(int centerX, int centerY, int segments, double innerRadius, double outerRadius, Color innerColor, Color outerColor) {
        this.drawRing(OwoUIPipelines.GUI_TRIANGLE_STRIP, centerX, centerY, segments, innerRadius, outerRadius, innerColor, outerColor);
    }

    public void drawRing(int centerX, int centerY, double angleFrom, double angleTo, int segments, double innerRadius, double outerRadius, Color innerColor, Color outerColor) {
        this.drawRing(OwoUIPipelines.GUI_TRIANGLE_STRIP, centerX, centerY, angleFrom, angleTo, segments, innerRadius, outerRadius, innerColor, outerColor);
    }

    public void drawRing(RenderPipeline pipeline, int centerX, int centerY, int segments, double innerRadius, double outerRadius, Color innerColor, Color outerColor) {
        this.drawRing(pipeline, centerX, centerY, 0.0, 360.0, segments, innerRadius, outerRadius, innerColor, outerColor);
    }

    public void drawRing(RenderPipeline pipeline, int centerX, int centerY, double angleFrom, double angleTo, int segments, double innerRadius, double outerRadius, Color innerColor, Color outerColor) {
        Preconditions.checkArgument((angleFrom < angleTo ? 1 : 0) != 0, (Object)"angleFrom must be less than angleTo");
        Preconditions.checkArgument((innerRadius < outerRadius ? 1 : 0) != 0, (Object)"innerRadius must be less than outerRadius");
        this.guiRenderState.submitGuiElement((GuiElementRenderState)new RingElementRenderState(pipeline, new Matrix3x2f((Matrix3x2fc)this.pose()), this.scissorStack.peek(), centerX, centerY, angleFrom, angleTo, segments, innerRadius, outerRadius, innerColor, outerColor));
    }

    public void drawTooltip(Font textRenderer, int x, int y, List<ClientTooltipComponent> components) {
        this.drawTooltip(textRenderer, x, y, components, null);
    }

    public void drawTooltip(Font textRenderer, int x, int y, List<ClientTooltipComponent> components, @Nullable ResourceLocation texture) {
        ((DrawContextAccessor)((Object)this)).owo$drawTooltipImmediately(textRenderer, components, x, y, DefaultTooltipPositioner.INSTANCE, texture);
    }

    protected void setTooltipForNextFrameInternal(Font textRenderer, List<ClientTooltipComponent> components, int x, int y, ClientTooltipPositioner positioner, @Nullable ResourceLocation texture, boolean focused) {
        super.setTooltipForNextFrameInternal(textRenderer, components, x, y, positioner, texture, focused);
        this.setTooltipDrawer.accept(((DrawContextAccessor)((Object)this)).owo$getTooltipDrawer());
    }

    public void drawInsets(int x, int y, int width, int height, Insets insets, int color) {
        this.drawInsets(RenderPipelines.GUI, x, y, width, height, insets, color);
    }

    public void drawInsets(RenderPipeline pipeline, int x, int y, int width, int height, Insets insets, int color) {
        this.fill(pipeline, x - insets.left(), y - insets.top(), x + width + insets.right(), y, color);
        this.fill(pipeline, x - insets.left(), y + height, x + width + insets.right(), y + height + insets.bottom(), color);
        this.fill(pipeline, x - insets.left(), y, x, y + height, color);
        this.fill(pipeline, x + width, y, x + width + insets.right(), y + height, color);
    }

    public void drawInspector(ParentComponent root, double mouseX, double mouseY, boolean onlyHovered) {
        Minecraft client = Minecraft.getInstance();
        Font textRenderer = client.font;
        ArrayList<Component> children = new ArrayList<Component>();
        if (!onlyHovered) {
            root.collectDescendants(children);
        } else if (root.childAt((int)mouseX, (int)mouseY) != null) {
            children.add(root.childAt((int)mouseX, (int)mouseY));
        }
        RenderPipeline pipeline = RenderPipelines.GUI;
        for (Component child : children) {
            if (child instanceof ParentComponent) {
                ParentComponent parentComponent = (ParentComponent)child;
                this.drawInsets(pipeline, parentComponent.x(), parentComponent.y(), parentComponent.width(), parentComponent.height(), ((Insets)parentComponent.padding().get()).inverted(), -1492325155);
            }
            Insets margins = (Insets)child.margins().get();
            this.drawInsets(pipeline, child.x(), child.y(), child.width(), child.height(), margins, -1476398280);
            this.drawRectOutline(pipeline, child.x(), child.y(), child.width(), child.height(), -12930817);
            if (!onlyHovered) continue;
            int inspectorX = child.x() + 1;
            int inspectorY = child.y() + child.height() + ((Insets)child.margins().get()).bottom() + 1;
            Objects.requireNonNull(textRenderer);
            int inspectorHeight = 9 * 2 + 4;
            if (inspectorY > client.getWindow().getGuiScaledHeight() - inspectorHeight) {
                if ((inspectorY -= child.fullSize().height() + inspectorHeight + 1) < 0) {
                    inspectorY = 1;
                }
                if (child instanceof ParentComponent) {
                    ParentComponent parentComponent = (ParentComponent)child;
                    inspectorX += ((Insets)parentComponent.padding().get()).left();
                    inspectorY += ((Insets)parentComponent.padding().get()).top();
                }
            }
            net.minecraft.network.chat.Component nameText = net.minecraft.network.chat.Component.nullToEmpty((String)(child.getClass().getSimpleName() + (String)(child.id() != null ? " '" + child.id() + "'" : "")));
            MutableComponent descriptor = net.minecraft.network.chat.Component.literal((String)(child.x() + "," + child.y() + " (" + child.width() + "," + child.height() + ") <" + margins.top() + "," + margins.bottom() + "," + margins.left() + "," + margins.right() + "> "));
            if (child instanceof ParentComponent) {
                ParentComponent parentComponent = (ParentComponent)child;
                Insets padding = (Insets)parentComponent.padding().get();
                descriptor.append(" >" + padding.top() + "," + padding.bottom() + "," + padding.left() + "," + padding.right() + "<");
            }
            int width = Math.max(textRenderer.width((FormattedText)nameText), textRenderer.width((FormattedText)descriptor));
            this.fill(pipeline, inspectorX, inspectorY, inspectorX + width + 3, inspectorY + inspectorHeight, -1493172224);
            this.drawRectOutline(pipeline, inspectorX, inspectorY, width + 3, inspectorHeight, -1493172224);
            this.drawString(textRenderer, nameText, inspectorX + 2, inspectorY + 2, -1, false);
            Objects.requireNonNull(textRenderer);
            this.drawString(textRenderer, (net.minecraft.network.chat.Component)descriptor, inspectorX + 2, inspectorY + 9 + 2, -1, false);
        }
    }

    public static class UtilityScreen
    extends Screen {
        private static UtilityScreen INSTANCE;
        private Screen linkSourceScreen = null;

        private UtilityScreen() {
            super((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.empty());
        }

        public static UtilityScreen get() {
            if (INSTANCE == null) {
                INSTANCE = new UtilityScreen();
                Minecraft client = Minecraft.getInstance();
                INSTANCE.init(client, client.getWindow().getGuiScaledWidth(), client.getWindow().getGuiScaledHeight());
            }
            return INSTANCE;
        }

        public void setLinkSource(Screen screen) {
            this.linkSourceScreen = screen;
        }

        public void captureLinkSource() {
            this.setLinkSource(this.minecraft.screen);
        }

        @ApiStatus.Internal
        @Nullable
        public Screen getAndClearLinkSource() {
            Screen source = this.linkSourceScreen;
            this.linkSourceScreen = null;
            return source;
        }

        public boolean handleComponentClicked(Style style) {
            return super.handleComponentClicked(style);
        }

        static {
            WindowResizeCallback.EVENT.register((client, window) -> {
                if (INSTANCE == null) {
                    return;
                }
                INSTANCE.init(client, window.getGuiScaledWidth(), window.getGuiScaledHeight());
            });
        }
    }

    public static enum TextAnchor {
        TOP_RIGHT,
        BOTTOM_RIGHT,
        TOP_LEFT,
        BOTTOM_LEFT;

    }
}

