/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.core;

import io.wispforest.owo.ui.core.AnimatableProperty;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.parsing.IncompatibleUIModelException;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.input.MouseButtonEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public interface ParentComponent
extends Component {
    public void layout(Size var1);

    public void onChildMutated(Component var1);

    public void queue(Runnable var1);

    default public ParentComponent alignment(HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        this.horizontalAlignment(horizontalAlignment);
        this.verticalAlignment(verticalAlignment);
        return this;
    }

    public ParentComponent verticalAlignment(VerticalAlignment var1);

    public VerticalAlignment verticalAlignment();

    public ParentComponent horizontalAlignment(HorizontalAlignment var1);

    public HorizontalAlignment horizontalAlignment();

    public ParentComponent padding(Insets var1);

    public AnimatableProperty<Insets> padding();

    public ParentComponent allowOverflow(boolean var1);

    public boolean allowOverflow();

    public ParentComponent surface(Surface var1);

    public Surface surface();

    public List<Component> children();

    public ParentComponent removeChild(Component var1);

    @Override
    default public void drawTooltip(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        if (this.hasParent()) {
            Component.super.drawTooltip(context, mouseX, mouseY, partialTicks, delta);
            return;
        }
        ArrayList hoveredDescendants = new ArrayList();
        this.forEachDescendantWhere(hoveredDescendants::add, component -> component.isInBoundingBox(mouseX, mouseY));
        hoveredDescendants.remove(this);
        for (int i = hoveredDescendants.size() - 1; i >= 0; --i) {
            ParentComponent nextParent = null;
            for (int parentIdx = i - 1; parentIdx >= 0; --parentIdx) {
                ParentComponent parent;
                Object e = hoveredDescendants.get(parentIdx);
                if (!(e instanceof ParentComponent)) continue;
                nextParent = parent = (ParentComponent)e;
                break;
            }
            Component current = (Component)hoveredDescendants.get(i);
            if (nextParent != null && current.parent() != nextParent) break;
            if (!current.shouldDrawTooltip(mouseX, mouseY)) continue;
            context.push();
            while (i >= 0 && (i <= 0 || ((Component)hoveredDescendants.get(i)).parent() == hoveredDescendants.get(i - 1))) {
                context.translate(0.0f, 0.0f);
                --i;
            }
            current.drawTooltip(context, mouseX, mouseY, partialTicks, delta);
            context.pop();
            break;
        }
    }

    @Override
    default public boolean onMouseDown(MouseButtonEvent click, boolean doubled) {
        ListIterator<Component> iter = this.children().listIterator(this.children().size());
        while (iter.hasPrevious()) {
            Component child = iter.previous();
            if (!child.isInBoundingBox((double)this.x() + click.x(), (double)this.y() + click.y()) || !child.onMouseDown(new MouseButtonEvent((double)this.x() + click.x() - (double)child.x(), (double)this.y() + click.y() - (double)child.y(), click.buttonInfo()), doubled)) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean onMouseScroll(double mouseX, double mouseY, double amount) {
        ListIterator<Component> iter = this.children().listIterator(this.children().size());
        while (iter.hasPrevious()) {
            Component child = iter.previous();
            if (!child.isInBoundingBox((double)this.x() + mouseX, (double)this.y() + mouseY) || !child.onMouseScroll((double)this.x() + mouseX - (double)child.x(), (double)this.y() + mouseY - (double)child.y(), amount)) continue;
            return true;
        }
        return false;
    }

    @Override
    default public void update(float delta, int mouseX, int mouseY) {
        this.padding().update(delta);
        for (int i = 0; i < this.children().size(); ++i) {
            this.children().get(i).update(delta, mouseX, mouseY);
        }
    }

    @Override
    default public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        Component.super.parseProperties(model, element, children);
        UIParsing.apply(children, "padding", Insets::parse, this::padding);
        UIParsing.apply(children, "surface", Surface::parse, this::surface);
        UIParsing.apply(children, "vertical-alignment", VerticalAlignment::parse, this::verticalAlignment);
        UIParsing.apply(children, "horizontal-alignment", HorizontalAlignment::parse, this::horizontalAlignment);
        UIParsing.apply(children, "allow-overflow", UIParsing::parseBool, this::allowOverflow);
    }

    default public <T extends Component> T childById(@NotNull Class<T> expectedClass, @NotNull String id) {
        ListIterator<Component> iter = this.children().listIterator(this.children().size());
        while (iter.hasPrevious()) {
            ParentComponent parent;
            T candidate;
            Component child = iter.previous();
            if (Objects.equals(child.id(), id)) {
                if (!expectedClass.isAssignableFrom(child.getClass())) {
                    throw new IncompatibleUIModelException("Expected child with id '" + id + "' to be a " + expectedClass.getSimpleName() + " but it is a " + child.getClass().getSimpleName());
                }
                return (T)child;
            }
            if (!(child instanceof ParentComponent) || (candidate = (parent = (ParentComponent)child).childById(expectedClass, id)) == null) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    default public Component childAt(int x, int y) {
        ListIterator<Component> iter = this.children().listIterator(this.children().size());
        while (iter.hasPrevious()) {
            Component child = iter.previous();
            if (!child.isInBoundingBox(x, y)) continue;
            if (child instanceof ParentComponent) {
                ParentComponent parent = (ParentComponent)child;
                return parent.childAt(x, y);
            }
            return child;
        }
        return this.isInBoundingBox(x, y) ? this : null;
    }

    default public void collectDescendants(ArrayList<Component> into) {
        this.forEachDescendant(into::add);
    }

    default public void forEachDescendant(Consumer<Component> action) {
        action.accept(this);
        for (Component child : this.children()) {
            if (child instanceof ParentComponent) {
                ParentComponent parent = (ParentComponent)child;
                parent.forEachDescendant(action);
                continue;
            }
            action.accept(child);
        }
    }

    default public void forEachDescendantWhere(Consumer<Component> action, Predicate<Component> condition) {
        action.accept(this);
        for (Component child : this.children()) {
            if (!condition.test(child)) continue;
            if (child instanceof ParentComponent) {
                ParentComponent parent = (ParentComponent)child;
                parent.forEachDescendantWhere(action, condition);
                continue;
            }
            action.accept(child);
        }
    }
}

