/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.core;

import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.parsing.UIModelParsingException;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.renderstate.BlurQuadElementRenderState;
import io.wispforest.owo.ui.renderstate.CubeMapElementRenderState;
import io.wispforest.owo.ui.util.NinePatchTexture;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.w3c.dom.Element;

public interface Surface {
    public static final Surface BLANK = (context, component) -> {};
    public static final Surface PANEL = (context, component) -> context.drawPanel(component.x(), component.y(), component.width(), component.height(), false);
    public static final Surface DARK_PANEL = (context, component) -> context.drawPanel(component.x(), component.y(), component.width(), component.height(), true);
    public static final Surface PANEL_INSET = (context, component) -> NinePatchTexture.draw(OwoUIDrawContext.PANEL_INSET_NINE_PATCH_TEXTURE, context, component);
    public static final Surface VANILLA_TRANSLUCENT = (context, component) -> context.drawGradientRect(component.x(), component.y(), component.width(), component.height(), -1072689136, -1072689136, -804253680, -804253680);
    public static final Surface TOOLTIP = Surface.tooltip(null);

    public static Surface tooltip(@Nullable ResourceLocation texture) {
        return (context, component) -> TooltipRenderUtil.renderTooltipBackground((GuiGraphics)context, (int)(component.x() + 4), (int)(component.y() + 4), (int)(component.width() - 8), (int)(component.height() - 8), (ResourceLocation)texture);
    }

    public static Surface blur(float quality, float size) {
        return (context, component) -> context.guiRenderState.submitGuiElement((GuiElementRenderState)new BlurQuadElementRenderState(new Matrix3x2f((Matrix3x2fc)context.pose()), new ScreenRectangle(component.x(), component.y(), component.width(), component.height()), context.scissorStack.peek(), 16, quality, size));
    }

    public static Surface optionsBackground() {
        return Surface.vanillaPanorama(false).and(Surface.blur(5.0f, 10.0f));
    }

    public static Surface vanillaPanorama(boolean alwaysVisible) {
        return Surface.panorama(Minecraft.getInstance().gameRenderer.getPanorama(), alwaysVisible);
    }

    public static Surface panorama(PanoramaRenderer renderer, boolean alwaysVisible) {
        return (context, component) -> {
            if (!alwaysVisible && Minecraft.getInstance().level != null) {
                return;
            }
            context.guiRenderState.submitPicturesInPictureState((PictureInPictureRenderState)new CubeMapElementRenderState(renderer, true, new ScreenRectangle(component.x(), component.y(), component.width(), component.height()), context.scissorStack.peek()));
        };
    }

    public static Surface flat(int color) {
        return (context, component) -> context.fill(component.x(), component.y(), component.x() + component.width(), component.y() + component.height(), color);
    }

    public static Surface outline(int color) {
        return (context, component) -> context.drawRectOutline(component.x(), component.y(), component.width(), component.height(), color);
    }

    public static Surface tiled(ResourceLocation texture, int textureWidth, int textureHeight) {
        return (context, component) -> context.blit(RenderPipelines.GUI_TEXTURED, texture, component.x(), component.y(), 0.0f, 0.0f, component.width(), component.height(), textureWidth, textureHeight);
    }

    public static Surface panelWithInset(int insetWidth) {
        return PANEL.and((context, component) -> NinePatchTexture.draw(OwoUIDrawContext.PANEL_INSET_NINE_PATCH_TEXTURE, context, component.x() + insetWidth, component.y() + insetWidth, component.width() - insetWidth * 2, component.height() - insetWidth * 2));
    }

    public void draw(OwoUIDrawContext var1, ParentComponent var2);

    default public Surface and(Surface surface) {
        return (context, component) -> {
            this.draw(context, component);
            surface.draw(context, component);
        };
    }

    public static Surface parse(Element surfaceElement) {
        List<Element> children = UIParsing.allChildrenOfType(surfaceElement, (short)1);
        Surface surface = BLANK;
        for (Element child : children) {
            surface = switch (child.getNodeName()) {
                case "panel" -> surface.and(child.getAttribute("dark").equalsIgnoreCase("true") ? DARK_PANEL : PANEL);
                case "tiled" -> {
                    UIParsing.expectAttributes(child, "texture-width", "texture-height");
                    yield surface.and(Surface.tiled(UIParsing.parseIdentifier(child), UIParsing.parseUnsignedInt(child.getAttributeNode("texture-width")), UIParsing.parseUnsignedInt(child.getAttributeNode("texture-height"))));
                }
                case "blur" -> {
                    UIParsing.expectAttributes(child, "size", "quality");
                    yield surface.and(Surface.blur(UIParsing.parseFloat(child.getAttributeNode("quality")), UIParsing.parseFloat(child.getAttributeNode("size"))));
                }
                case "panel-with-inset" -> surface.and(Surface.panelWithInset(UIParsing.parseUnsignedInt(child)));
                case "options-background" -> surface.and(Surface.optionsBackground());
                case "vanilla-translucent" -> surface.and(VANILLA_TRANSLUCENT);
                case "panel-inset" -> surface.and(PANEL_INSET);
                case "tooltip" -> surface.and(TOOLTIP);
                case "outline" -> surface.and(Surface.outline(Color.parseAndPack(child)));
                case "flat" -> surface.and(Surface.flat(Color.parseAndPack(child)));
                default -> throw new UIModelParsingException("Unknown surface type '" + child.getNodeName() + "'");
            };
        }
        return surface;
    }
}

