/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.hud;

import com.mojang.blaze3d.platform.Window;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.event.ClientRenderCallback;
import io.wispforest.owo.ui.event.WindowResizeCallback;
import io.wispforest.owo.ui.hud.HudContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.gui.GuiLayerManager;
import org.jetbrains.annotations.Nullable;

public class Hud {
    @Nullable
    static OwoUIAdapter<FlowLayout> adapter = null;
    static boolean suppress = false;
    private static final Map<ResourceLocation, Component> activeComponents = new HashMap<ResourceLocation, Component>();
    private static final List<Consumer<FlowLayout>> pendingActions = new ArrayList<Consumer<FlowLayout>>();
    public static final GuiLayerManager.NamedLayer HUD_LAYER;

    public static void add(ResourceLocation id, Supplier<Component> component) {
        pendingActions.add(flowLayout -> {
            Component instance = (Component)component.get();
            flowLayout.child(instance);
            activeComponents.put(id, instance);
        });
    }

    public static void remove(ResourceLocation id) {
        pendingActions.add(flowLayout -> {
            Component component = activeComponents.get(id);
            if (component == null) {
                return;
            }
            flowLayout.removeChild(component);
            activeComponents.remove(id);
        });
    }

    @Nullable
    public static Component getComponent(ResourceLocation id) {
        return activeComponents.get(id);
    }

    public static boolean hasComponent(ResourceLocation id) {
        return activeComponents.containsKey(id);
    }

    private static void initializeAdapter() {
        Window window = Minecraft.getInstance().getWindow();
        adapter = OwoUIAdapter.createWithoutScreen(0, 0, window.getGuiScaledWidth(), window.getGuiScaledHeight(), HudContainer::new);
        adapter.inflateAndMount();
    }

    static {
        WindowResizeCallback.EVENT.register((client, window) -> {
            if (adapter == null) {
                return;
            }
            adapter.moveAndResize(0, 0, window.getGuiScaledWidth(), window.getGuiScaledHeight());
        });
        ClientRenderCallback.BEFORE.register(client -> {
            if (client.level == null) {
                return;
            }
            if (!pendingActions.isEmpty()) {
                if (adapter == null) {
                    Hud.initializeAdapter();
                }
                pendingActions.forEach(action -> action.accept((FlowLayout)Hud.adapter.rootComponent));
                pendingActions.clear();
            }
        });
        HUD_LAYER = new GuiLayerManager.NamedLayer(ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"owo_ui_hud"), (context, tickCounter) -> {
            if (adapter == null || suppress || Minecraft.getInstance().options.hideGui) {
                return;
            }
            adapter.render(context, -69, -69, tickCounter.getGameTimeDeltaPartialTick(false));
        });
    }
}

