/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.renderstate;

import com.google.common.collect.MapMaker;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.buffers.Std140Builder;
import com.mojang.blaze3d.buffers.Std140SizeCalculator;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.wispforest.owo.ui.core.OwoUIPipelines;
import io.wispforest.owo.ui.event.ClientRenderCallback;
import io.wispforest.owo.ui.event.WindowResizeCallback;
import java.nio.ByteBuffer;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.renderer.DynamicUniformStorage;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Vector2i;

public record BlurQuadElementRenderState(RenderPipeline pipeline, Matrix3x2f pose, ScreenRectangle bounds, ScreenRectangle scissorArea, TextureSetup textureSetup) implements GuiElementRenderState
{
    private final ScreenRectangle bounds;
    public static Uniforms uniforms;
    public static RenderTarget input;
    public static GpuTextureView inputView;
    private static final Map<TextureSetup, BlurSetup> blurSetups;

    public BlurQuadElementRenderState(Matrix3x2f pose, ScreenRectangle bounds, ScreenRectangle scissorArea, int directions, float quality, float size) {
        this(OwoUIPipelines.GUI_BLUR, pose, bounds, scissorArea, BlurQuadElementRenderState.createTextureSetup(directions, quality, size));
    }

    @ApiStatus.Internal
    public static void initialize(Minecraft client) {
        uniforms = new Uniforms();
        Window window = client.getWindow();
        input = new TextureTarget("owo_blur_input", window.getWidth(), window.getHeight(), false);
        inputView = RenderSystem.getDevice().createTextureView(input.getColorTexture());
        WindowResizeCallback.EVENT.register((innerClient, innerWindow) -> {
            if (input == null) {
                return;
            }
            input.resize(innerWindow.getWidth(), innerWindow.getHeight());
            inputView.close();
            inputView = RenderSystem.getDevice().createTextureView(input.getColorTexture());
        });
        ClientRenderCallback.AFTER.register($ -> uniforms.clear());
    }

    public void buildVertices(VertexConsumer vertices) {
        vertices.addVertexWith2DPose(this.pose(), (float)this.bounds.left(), (float)this.bounds.top());
        vertices.addVertexWith2DPose(this.pose(), (float)this.bounds.left(), (float)this.bounds.bottom());
        vertices.addVertexWith2DPose(this.pose(), (float)this.bounds.right(), (float)this.bounds.bottom());
        vertices.addVertexWith2DPose(this.pose(), (float)this.bounds.right(), (float)this.bounds.top());
    }

    @Nullable
    public ScreenRectangle bounds() {
        return this.scissorArea != null ? this.scissorArea.intersection(this.bounds) : this.bounds;
    }

    public static boolean hasBlurSetupFor(TextureSetup textureSetup) {
        return blurSetups.containsKey(textureSetup);
    }

    @Nullable
    public static BlurSetup getBlurSetupOf(TextureSetup textureSetup) {
        return blurSetups.get(textureSetup);
    }

    private static TextureSetup createTextureSetup(int directions, float quality, float size) {
        TextureSetup setup = TextureSetup.singleTexture(null);
        blurSetups.put(setup, new BlurSetup(directions, quality, size));
        return setup;
    }

    static {
        blurSetups = new MapMaker().weakKeys().makeMap();
    }

    public static class Uniforms {
        public static final int SIZE = new Std140SizeCalculator().putVec2().putFloat().putFloat().putFloat().get();
        private final DynamicUniformStorage<Value> storage = new DynamicUniformStorage("Blur Settings UBO", SIZE, 4);

        public void clear() {
            this.storage.endFrame();
        }

        public GpuBufferSlice write(Vector2i inputResolution, int directions, float quality, float size) {
            return this.storage.writeUniform((DynamicUniformStorage.DynamicUniform)new Value(inputResolution, directions, quality, size));
        }

        public record Value(Vector2i inputResolution, int directions, float quality, float size) implements DynamicUniformStorage.DynamicUniform
        {
            public void write(ByteBuffer buffer) {
                Std140Builder.intoBuffer((ByteBuffer)buffer).putVec2((float)this.inputResolution.x, (float)this.inputResolution.y).putFloat((float)this.directions).putFloat(this.quality).putFloat(this.size);
            }
        }
    }

    public record BlurSetup(int directions, float quality, float size) {
    }
}

