/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.renderstate;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.PanoramaRenderer;
import org.jetbrains.annotations.Nullable;

public record CubeMapElementRenderState(PanoramaRenderer cubeMap, boolean rotate, ScreenRectangle bounds, ScreenRectangle scissorArea) implements PictureInPictureRenderState
{
    private final ScreenRectangle bounds;
    public static OutputOverride outputOverride = null;

    public int x0() {
        return this.bounds.left();
    }

    public int x1() {
        return this.bounds.right();
    }

    public int y0() {
        return this.bounds.top();
    }

    public int y1() {
        return this.bounds.bottom();
    }

    public float scale() {
        return 1.0f;
    }

    @Nullable
    public ScreenRectangle bounds() {
        return this.scissorArea != null ? this.scissorArea.intersection(this.bounds) : this.bounds;
    }

    public record OutputOverride(GpuTextureView color, GpuTextureView depth, int resetColor) {
    }

    public static class Renderer
    extends PictureInPictureRenderer<CubeMapElementRenderState> {
        private static GuiGraphics dummyContext;

        protected Renderer(MultiBufferSource.BufferSource vertexConsumers) {
            super(vertexConsumers);
        }

        public Class<CubeMapElementRenderState> getRenderStateClass() {
            return CubeMapElementRenderState.class;
        }

        protected void render(CubeMapElementRenderState state, PoseStack matrices) {
            if (dummyContext == null) {
                dummyContext = new GuiGraphics(Minecraft.getInstance(), new GuiRenderState());
            }
            Renderer.dummyContext.guiRenderState.reset();
            try {
                outputOverride = new OutputOverride(RenderSystem.outputColorTextureOverride, RenderSystem.outputDepthTextureOverride, -16777216);
                state.cubeMap.render(dummyContext, state.bounds.width(), state.bounds.height(), state.rotate());
            }
            finally {
                outputOverride = null;
            }
        }

        protected String getTextureLabel() {
            return "owo-ui_cubemap";
        }
    }
}

