/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.renderstate;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.feature.FeatureRenderDispatcher;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import org.jetbrains.annotations.Nullable;

public record LargeItemElementRenderState(ItemStackRenderState item, ScreenRectangle bounds, ScreenRectangle scissorArea) implements PictureInPictureRenderState
{
    private final ScreenRectangle bounds;

    public int x0() {
        return this.bounds.left();
    }

    public int x1() {
        return this.bounds.right();
    }

    public int y0() {
        return this.bounds.top();
    }

    public int y1() {
        return this.bounds.bottom();
    }

    public float scale() {
        return 1.0f;
    }

    @Nullable
    public ScreenRectangle bounds() {
        return this.scissorArea != null ? this.scissorArea.intersection(this.bounds) : this.bounds;
    }

    public static class Renderer
    extends PictureInPictureRenderer<LargeItemElementRenderState> {
        public Renderer(MultiBufferSource.BufferSource vertexConsumers) {
            super(vertexConsumers);
        }

        public Class<LargeItemElementRenderState> getRenderStateClass() {
            return LargeItemElementRenderState.class;
        }

        protected void render(LargeItemElementRenderState state, PoseStack matrices) {
            boolean notSideLit;
            matrices.scale((float)state.bounds.width(), (float)(-state.bounds.height()), (float)(-Math.min(state.bounds.width(), state.bounds.height())));
            boolean bl = notSideLit = !state.item.usesBlockLight();
            if (notSideLit) {
                Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ITEMS_FLAT);
            } else {
                Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ITEMS_3D);
            }
            FeatureRenderDispatcher dispatcher = Minecraft.getInstance().gameRenderer.getFeatureRenderDispatcher();
            state.item.submit(matrices, (SubmitNodeCollector)dispatcher.getSubmitNodeStorage(), 0xF000F0, OverlayTexture.NO_OVERLAY, 0);
            dispatcher.renderAllFeatures();
        }

        protected float getTranslateY(int height, int windowScaleFactor) {
            return (float)height / 2.0f;
        }

        protected String getTextureLabel() {
            return "owo-ui_large_item";
        }
    }
}

