package io.wispforest.owo.mixin;

import io.wispforest.owo.network.OwoClientConnectionExtension;
import io.wispforest.owo.network.OwoHandshake;
import io.wispforest.owo.network.QueuedChannelSet;
import io.wispforest.owo.ops.TextOps;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientCommonPacketListenerImpl;
import net.minecraft.client.multiplayer.ClientConfigurationPacketListenerImpl;
import net.minecraft.client.multiplayer.CommonListenerCookie;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.configuration.ClientboundFinishConfigurationPacket;
import net.neoforged.neoforge.network.registration.NetworkRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(ClientConfigurationPacketListenerImpl.class)
public abstract class ClientConfigurationNetworkHandlerMixin extends ClientCommonPacketListenerImpl {

    protected ClientConfigurationNetworkHandlerMixin(Minecraft client, Connection connection, CommonListenerCookie connectionState) {
        super(client, connection, connectionState);
    }

    @ModifyArg(method = "onReady", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/ClientPlayNetworkHandler;<init>(Lnet/minecraft/client/MinecraftClient;Lnet/minecraft/network/ClientConnection;Lnet/minecraft/client/network/ClientConnectionState;)V"))
    private Connection applyChannelSet(Connection connection) {
        ((OwoClientConnectionExtension) connection).owo$setChannelSet(QueuedChannelSet.channels);
        QueuedChannelSet.channels = null;

        return connection;
    }

    //--

    @Inject(method = "onReady", at = @At(value = "NEW", target = "(Lnet/minecraft/client/MinecraftClient;Lnet/minecraft/network/ClientConnection;Lnet/minecraft/client/network/ClientConnectionState;)Lnet/minecraft/client/network/ClientPlayNetworkHandler;"))
    public void owoNeo$handleComplete(ClientboundFinishConfigurationPacket packet, CallbackInfo ci) {
        // TODO: Report issues with ClientConfigurationNetworking.canSend(CHANNEL_ID)
        if (NetworkRegistry.hasChannel((ClientConfigurationPacketListenerImpl) (Object) this, OwoHandshake.CHANNEL_ID) || !OwoHandshake.handshakeRequired() || !OwoHandshake.ENABLED) return;

        this.minecraft.execute(() -> {
            ((ClientCommonNetworkHandlerAccessor) (ClientConfigurationPacketListenerImpl) (Object) this)
                    .getConnection()
                    .disconnect(TextOps.concat(OwoHandshake.PREFIX, Component.nullToEmpty("incompatible server")));
        });
    }

}
