package io.wispforest.owo.mixin.ui.access;

import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;

import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.resources.ResourceLocation;

@Mixin(GuiGraphics.class)
public interface DrawContextAccessor {

    @Invoker("drawTooltipImmediately")
    void owo$drawTooltipImmediately(Font textRenderer, List<ClientTooltipComponent> components, int x, int y, ClientTooltipPositioner positioner, @Nullable ResourceLocation texture);

    @Accessor("matrices")
    Matrix3x2fStack owo$getMatrices();

    @Mutable
    @Accessor("matrices")
    void owo$setMatrices(Matrix3x2fStack matrices);

    @Accessor("scissorStack")
    GuiGraphics.ScissorStack owo$getScissorStack();

    @Mutable
    @Accessor("scissorStack")
    void owo$setScissorStack(GuiGraphics.ScissorStack scissorStack);

    @Accessor("tooltipDrawer")
    void owo$setTooltipDrawer(Runnable drawer);

    @Accessor("tooltipDrawer")
    Runnable owo$getTooltipDrawer();
}
