/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo;

import io.wispforest.owo.command.debug.OwoDebugCommands;
import io.wispforest.owo.network.neoforge.NeoOwoNetworking;
import io.wispforest.owo.ops.LootOps;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.util.OwoFreezer;
import io.wispforest.owo.util.RecipeRemainderStorage;
import io.wispforest.owo.util.Wisdom;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="owo")
public class Owo {
    public static final boolean DEBUG;
    public static final Logger LOGGER;
    public static final Component PREFIX;
    @Nullable
    private static IEventBus MOD_BUS;

    public Owo(IEventBus modBus) {
        MOD_BUS = modBus;
        LootOps.registerListener();
        modBus.addListener(event -> OwoFreezer.freeze());
        Wisdom.spread();
        modBus.addListener(NeoOwoNetworking::onNetworkRegister);
        NeoForge.EVENT_BUS.addListener(RecipeRemainderStorage::addReloadListener);
        if (DEBUG) {
            OwoDebugCommands.register(modBus);
        }
    }

    @ApiStatus.Internal
    public static void debugWarn(Logger logger, String message) {
        if (!DEBUG) {
            return;
        }
        logger.warn(message);
    }

    @ApiStatus.Internal
    public static void debugWarn(Logger logger, String message, Object ... params) {
        if (!DEBUG) {
            return;
        }
        logger.warn(message, params);
    }

    public static MinecraftServer currentServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public static IEventBus getModBus() {
        return Objects.requireNonNull(MOD_BUS, "Mod bus attempted to be gotten before time!");
    }

    static {
        boolean debug;
        LOGGER = LoggerFactory.getLogger((String)"owo");
        PREFIX = Component.empty().withStyle(ChatFormatting.GRAY).append((Component)TextOps.withColor("o", 3757541)).append((Component)TextOps.withColor("\u03c9", 1287920)).append((Component)TextOps.withColor("o", 3757541)).append((Component)Component.literal((String)" > ").withStyle(ChatFormatting.GRAY));
        boolean bl = debug = !FMLLoader.getCurrent().isProduction();
        if (System.getProperty("owo.debug") != null) {
            debug = Boolean.getBoolean("owo.debug");
        }
        if (Boolean.getBoolean("owo.forceDisableDebug")) {
            LOGGER.warn("Deprecated system property 'owo.forceDisableDebug=true' was used - use 'owo.debug=false' instead");
            debug = false;
        }
        DEBUG = debug;
        MOD_BUS = null;
    }
}

