/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.wispforest.owo.Owo;
import io.wispforest.owo.config.OwoConfigCommand;
import io.wispforest.owo.config.ui.ConfigScreenProviders;
import io.wispforest.owo.itemgroup.json.OwoItemGroupLoader;
import io.wispforest.owo.moddata.ModDataLoader;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.renderdoc.RenderDoc;
import io.wispforest.owo.renderdoc.RenderdocScreen;
import io.wispforest.owo.ui.core.OwoUIPipelines;
import io.wispforest.owo.ui.hud.Hud;
import io.wispforest.owo.ui.hud.HudInspectorScreen;
import io.wispforest.owo.ui.parsing.ConfigureHotReloadScreen;
import io.wispforest.owo.ui.parsing.UIModelLoader;
import io.wispforest.owo.ui.renderstate.OwoSpecialGuiElementRenderers;
import io.wispforest.owo.ui.util.NinePatchTexture;
import io.wispforest.owo.util.pond.OwoScreenHandlerExtension;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.ApiStatus;

@Mod(value="owo", dist={Dist.CLIENT})
@ApiStatus.Internal
public class OwoClient {
    private static final String LINUX_RENDERDOC_WARNING = "\n========================================\nIgnored 'owo.renderdocPath' property as this Minecraft instance is not running on Windows.\nPlease populate the LD_PRELOAD environment variable instead\n========================================";
    private static final String MAC_RENDERDOC_WARNING = "\n========================================\nIgnored 'owo.renderdocPath' property as this Minecraft instance is not running on Windows.\nRenderDoc is not supported on macOS\n========================================";
    private static final String GENERIC_RENDERDOC_WARNING = "\n========================================\nIgnored 'owo.renderdocPath' property as this Minecraft instance is not running on Windows.\n========================================";
    private static final SuggestionProvider<CommandSourceStack> LOADED_UI_MODELS = (context, builder) -> SharedSuggestionProvider.suggestResource(UIModelLoader.allLoadedModels(), (SuggestionsBuilder)builder);
    private static final SimpleCommandExceptionType NO_SUCH_UI_MODEL = new SimpleCommandExceptionType((Message)Component.literal((String)"No such UI model is loaded"));

    public OwoClient(IEventBus modBus) {
        String renderdocPath;
        ModDataLoader.load(OwoItemGroupLoader.INSTANCE);
        OwoItemGroupLoader.initItemGroupCallback();
        modBus.addListener(event -> {
            event.addListener(UIModelLoader.getFabricId(), (PreparableReloadListener)new UIModelLoader());
            event.addListener(NinePatchTexture.MetadataLoader.getFabricId(), (PreparableReloadListener)new NinePatchTexture.MetadataLoader());
        });
        modBus.addListener(OwoUIPipelines::register);
        if (Owo.DEBUG && (renderdocPath = System.getProperty("owo.renderdocPath")) != null) {
            if (Util.getPlatform() == Util.OS.WINDOWS) {
                System.load(renderdocPath);
            } else {
                Owo.LOGGER.warn(switch (Util.getPlatform()) {
                    case Util.OS.LINUX -> LINUX_RENDERDOC_WARNING;
                    case Util.OS.OSX -> MAC_RENDERDOC_WARNING;
                    default -> GENERIC_RENDERDOC_WARNING;
                });
            }
        }
        OwoClient.screenInternalsClientInit();
        NeoForge.EVENT_BUS.addListener(event -> OwoConfigCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext()));
        if (Owo.DEBUG) {
            OwoClient.owoDebugCommandsClientRegister();
        }
        OwoSpecialGuiElementRenderers.init(modBus);
        modBus.addListener(FMLClientSetupEvent.class, event -> ConfigScreenProviders.forEach((modId, screenFactory) -> ModList.get().getModContainerById(modId).ifPresent(mod -> mod.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(modContainer, modsScreen) -> (Screen)screenFactory.apply(modsScreen))))));
        modBus.addListener(RegisterGuiLayersEvent.class, event -> event.registerAboveAll(Hud.HUD_LAYER.name(), Hud.HUD_LAYER.layer()));
    }

    public static void screenInternalsClientInit() {
        NeoForge.EVENT_BUS.addListener(event -> {
            Screen patt0$temp = event.getScreen();
            if (patt0$temp instanceof MenuAccess) {
                MenuAccess handled = (MenuAccess)patt0$temp;
                ((OwoScreenHandlerExtension)handled.getMenu()).owo$attachToPlayer((Player)Minecraft.getInstance().player);
            }
        });
    }

    public static void owoDebugCommandsClientRegister() {
        NeoForge.EVENT_BUS.addListener(event -> {
            CommandDispatcher dispatcher = event.getDispatcher();
            CommandBuildContext registryAccess = event.getBuildContext();
            dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"owo-hud-inspect").executes(context -> {
                Minecraft.getInstance().setScreen((Screen)new HudInspectorScreen());
                return 0;
            }));
            dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"owo-ui-set-reload-path").then(Commands.argument((String)"model-id", (ArgumentType)ResourceLocationArgument.id()).suggests(LOADED_UI_MODELS).executes(context -> {
                ResourceLocation modelId = (ResourceLocation)context.getArgument("model-id", ResourceLocation.class);
                if (UIModelLoader.getPreloaded(modelId) == null) {
                    throw NO_SUCH_UI_MODEL.create();
                }
                Minecraft.getInstance().setScreen((Screen)new ConfigureHotReloadScreen(modelId, null));
                return 0;
            })));
            if (RenderDoc.isAvailable()) {
                dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"renderdoc").executes(context -> {
                    Minecraft.getInstance().setScreen((Screen)new RenderdocScreen());
                    return 1;
                })).then(Commands.literal((String)"comment").then(Commands.argument((String)"capture_index", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.argument((String)"comment", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
                    RenderDoc.Capture capture = RenderDoc.getCapture(IntegerArgumentType.getInteger((CommandContext)context, (String)"capture_index"));
                    if (capture == null) {
                        ((CommandSourceStack)context.getSource()).sendFailure((Component)TextOps.concat(Owo.PREFIX, Component.nullToEmpty((String)"no such capture")));
                        return 0;
                    }
                    RenderDoc.setCaptureComments(capture, StringArgumentType.getString((CommandContext)context, (String)"comment"));
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> TextOps.concat(Owo.PREFIX, Component.nullToEmpty((String)"comment updated")), false);
                    return 1;
                })))));
            }
        });
    }
}

