/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.command.debug;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import io.wispforest.owo.Owo;
import io.wispforest.owo.ops.TextOps;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class DumpdataCommand {
    private static final int GENERAL_PURPLE = 12157951;
    private static final int KEY_BLUE = 9745405;
    private static final int VALUE_BLUE = 9755391;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"dumpdata").then(((LiteralArgumentBuilder)Commands.literal((String)"item").executes(DumpdataCommand.withRootPath(DumpdataCommand::executeItem))).then(Commands.argument((String)"nbt_path", (ArgumentType)NbtPathArgument.nbtPath()).executes(DumpdataCommand.withPathArg(DumpdataCommand::executeItem))))).then(((LiteralArgumentBuilder)Commands.literal((String)"block").executes(DumpdataCommand.withRootPath(DumpdataCommand::executeBlock))).then(Commands.argument((String)"nbt_path", (ArgumentType)NbtPathArgument.nbtPath()).executes(DumpdataCommand.withPathArg(DumpdataCommand::executeBlock))))).then(((LiteralArgumentBuilder)Commands.literal((String)"entity").executes(DumpdataCommand.withRootPath(DumpdataCommand::executeEntity))).then(Commands.argument((String)"nbt_path", (ArgumentType)NbtPathArgument.nbtPath()).executes(DumpdataCommand.withPathArg(DumpdataCommand::executeEntity)))));
    }

    private static Command<CommandSourceStack> withRootPath(DataDumper dumper) {
        return context -> dumper.dump((CommandContext<CommandSourceStack>)context, NbtPathArgument.nbtPath().parse(new StringReader("")));
    }

    private static Command<CommandSourceStack> withPathArg(DataDumper dumper) {
        return context -> {
            NbtPathArgument.NbtPath path = NbtPathArgument.getPath((CommandContext)context, (String)"nbt_path");
            return dumper.dump((CommandContext<CommandSourceStack>)context, path);
        };
    }

    private static int executeItem(CommandContext<CommandSourceStack> context, NbtPathArgument.NbtPath path) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ItemStack stack = source.getPlayer().getMainHandItem();
        DumpdataCommand.informationHeader(source, "Item");
        DumpdataCommand.sendIdentifier(source, stack.getItem(), BuiltInRegistries.ITEM);
        if (stack.get(DataComponents.MAX_DAMAGE) != null) {
            DumpdataCommand.feedback(source, (Component)TextOps.withColor("Durability: \u00a7" + String.valueOf(stack.get(DataComponents.MAX_DAMAGE)), TextOps.color(ChatFormatting.GRAY), 9745405));
        } else {
            DumpdataCommand.feedback(source, (Component)TextOps.withFormatting("Not damageable", ChatFormatting.GRAY));
        }
        if (!stack.getComponentsPatch().isEmpty()) {
            DumpdataCommand.feedback(source, (Component)TextOps.withFormatting("Component changes" + DumpdataCommand.formatPath(path) + ": ", ChatFormatting.GRAY).append(NbtUtils.toPrettyComponent((Tag)DumpdataCommand.getPath((Tag)DataComponentPatch.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)stack.getComponentsPatch()).getOrThrow(), path))));
        } else {
            DumpdataCommand.feedback(source, (Component)TextOps.withFormatting("No component changes", ChatFormatting.GRAY));
        }
        DumpdataCommand.feedback(source, (Component)TextOps.withFormatting("-----------------------", ChatFormatting.GRAY));
        return 0;
    }

    private static int executeEntity(CommandContext<CommandSourceStack> context, NbtPathArgument.NbtPath path) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayer();
        EntityHitResult target = ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)player.getEyePosition(0.0f), (Vec3)player.getEyePosition(0.0f).add(player.getViewVector(0.0f).scale(5.0)), (AABB)player.getBoundingBox().expandTowards(player.getViewVector(0.0f).scale(5.0)).inflate(1.0), entity -> true, (double)25.0);
        if (target == null || target.getType() != HitResult.Type.ENTITY) {
            source.sendFailure((Component)TextOps.concat(Owo.PREFIX, (Component)Component.literal((String)"You're not looking at an entity")));
            return 1;
        }
        Entity entity2 = target.getEntity();
        DumpdataCommand.informationHeader(source, "Entity");
        DumpdataCommand.sendIdentifier(source, entity2.getType(), BuiltInRegistries.ENTITY_TYPE);
        TagValueOutput writeView = TagValueOutput.createWithoutContext((ProblemReporter)new ProblemReporter.ScopedCollector(Owo.LOGGER));
        entity2.save((ValueOutput)writeView);
        DumpdataCommand.feedback(source, (Component)TextOps.withFormatting("NBT" + DumpdataCommand.formatPath(path) + ": ", ChatFormatting.GRAY).append(NbtUtils.toPrettyComponent((Tag)DumpdataCommand.getPath((Tag)writeView.buildResult(), path))));
        DumpdataCommand.feedback(source, (Component)TextOps.withFormatting("-----------------------", ChatFormatting.GRAY));
        return 0;
    }

    private static int executeBlock(CommandContext<CommandSourceStack> context, NbtPathArgument.NbtPath path) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayer();
        HitResult target = player.pick(5.0, 0.0f, false);
        if (target.getType() != HitResult.Type.BLOCK) {
            source.sendFailure((Component)TextOps.concat(Owo.PREFIX, (Component)Component.literal((String)"You're not looking at a block")));
            return 1;
        }
        BlockPos pos = ((BlockHitResult)target).getBlockPos();
        BlockState blockState = player.level().getBlockState(pos);
        String blockStateString = blockState.toString();
        DumpdataCommand.informationHeader(source, "Block");
        DumpdataCommand.sendIdentifier(source, blockState.getBlock(), BuiltInRegistries.BLOCK);
        if (blockStateString.contains("[")) {
            String[] stateInfo;
            DumpdataCommand.feedback(source, (Component)TextOps.withFormatting("State properties: ", ChatFormatting.GRAY));
            String stateString = blockStateString.split(Pattern.quote("["))[1];
            stateString = stateString.substring(0, stateString.length() - 1);
            for (String property : stateInfo = stateString.replaceAll("=", ": \u00a7").split(",")) {
                DumpdataCommand.feedback(source, (Component)TextOps.withColor("    " + property, 9745405, 9755391));
            }
        } else {
            DumpdataCommand.feedback(source, (Component)TextOps.withFormatting("No state properties", ChatFormatting.GRAY));
        }
        BlockEntity blockEntity = player.level().getBlockEntity(pos);
        if (blockEntity != null) {
            DumpdataCommand.feedback(source, (Component)TextOps.withFormatting("Block Entity NBT" + DumpdataCommand.formatPath(path) + ": ", ChatFormatting.GRAY).append(NbtUtils.toPrettyComponent((Tag)DumpdataCommand.getPath((Tag)blockEntity.saveWithoutMetadata((HolderLookup.Provider)player.registryAccess()), path))));
        } else {
            DumpdataCommand.feedback(source, (Component)TextOps.withFormatting("No block entity", ChatFormatting.GRAY));
        }
        DumpdataCommand.feedback(source, (Component)TextOps.withFormatting("-----------------------", ChatFormatting.GRAY));
        return 0;
    }

    private static <T> void sendIdentifier(CommandSourceStack source, T object, Registry<T> registry) {
        String[] id = registry.getKey(object).toString().split(":");
        DumpdataCommand.feedback(source, (Component)TextOps.withColor("Identifier: \u00a7" + id[0] + ":\u00a7" + id[1], TextOps.color(ChatFormatting.GRAY), 9745405, 9755391));
    }

    private static void informationHeader(CommandSourceStack source, String name) {
        DumpdataCommand.feedback(source, (Component)TextOps.withColor("---[\u00a7 " + name + " Information \u00a7]---", TextOps.color(ChatFormatting.GRAY), 12157951, TextOps.color(ChatFormatting.GRAY)));
    }

    private static void feedback(CommandSourceStack source, Component message) {
        source.sendSuccess(() -> message, false);
    }

    private static String formatPath(NbtPathArgument.NbtPath path) {
        return path.toString().isBlank() ? "" : "(" + String.valueOf(path) + ")";
    }

    private static Tag getPath(Tag nbt, NbtPathArgument.NbtPath path) throws CommandSyntaxException {
        return (Tag)path.get(nbt).iterator().next();
    }

    @FunctionalInterface
    private static interface DataDumper {
        public int dump(CommandContext<CommandSourceStack> var1, NbtPathArgument.NbtPath var2) throws CommandSyntaxException;
    }
}

