/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.network;

import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.Owo;
import io.wispforest.owo.mixin.ServerCommonNetworkHandlerAccessor;
import io.wispforest.owo.network.OwoClientConnectionExtension;
import io.wispforest.owo.network.OwoNetChannel;
import io.wispforest.owo.network.QueuedChannelSet;
import io.wispforest.owo.network.neoforge.SidedPacketCodec;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.particles.systems.ParticleSystemController;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import io.wispforest.owo.util.OwoFreezer;
import io.wispforest.owo.util.ServicesFrozenException;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.ToIntFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.util.Tuple;
import net.neoforged.neoforge.common.extensions.ICommonPacketListener;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.handling.ServerPayloadContext;
import net.neoforged.neoforge.network.registration.NetworkRegistry;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class OwoHandshake {
    private static final Endec<Map<ResourceLocation, Integer>> CHANNEL_HASHES_ENDEC = Endec.map(MinecraftEndecs.IDENTIFIER, (Endec)Endec.INT);
    public static final MutableComponent PREFIX = TextOps.concat(Owo.PREFIX, Component.nullToEmpty((String)"\u00a7chandshake failure\n"));
    public static final ResourceLocation CHANNEL_ID = ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"handshake");
    public static final ResourceLocation OFF_CHANNEL_ID = ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"handshake_off");
    public static final boolean ENABLED = System.getProperty("owo.handshake.enabled") != null ? Boolean.getBoolean("owo.handshake.enabled") : Owo.DEBUG;
    private static boolean HANDSHAKE_REQUIRED = false;
    private static boolean QUERY_RECEIVED = false;

    private OwoHandshake() {
    }

    public static void enable() {
        if (OwoFreezer.isFrozen()) {
            throw new ServicesFrozenException("The o\u03c9o handshake may only be enabled during mod initialization");
        }
    }

    public static void requireHandshake() {
        if (OwoFreezer.isFrozen()) {
            throw new ServicesFrozenException("The o\u03c9o handshake may only be made required during mod initialization");
        }
        HANDSHAKE_REQUIRED = true;
    }

    public static void register(PayloadRegistrar registrar) {
        IPayloadHandler handler = (payload, context) -> {
            if (payload instanceof HandshakeRequest) {
                HandshakeRequest request = (HandshakeRequest)payload;
                OwoHandshake.syncClient(request, context);
            } else if (payload instanceof HandshakeResponse) {
                HandshakeResponse response = (HandshakeResponse)payload;
                OwoHandshake.syncServer(response, context);
            } else {
                throw new IllegalStateException("OWO_NEO: HOW DID YOU GET HERE!");
            }
        };
        registrar.configurationBidirectional(new CustomPacketPayload.Type(CHANNEL_ID), new SidedPacketCodec(CodecUtils.toPacketCodec(HandshakeResponse.ENDEC.xmap(response -> response, customPayload -> (HandshakeResponse)customPayload)), CodecUtils.toPacketCodec(HandshakeRequest.ENDEC.xmap(request -> request, customPayload -> (HandshakeRequest)customPayload))), handler, handler);
        Owo.getModBus().addListener(event -> {
            ServerConfigurationPacketListenerImpl listener = (ServerConfigurationPacketListenerImpl)event.getListener();
            OwoHandshake.configureStart(listener, ((ServerCommonNetworkHandlerAccessor)listener).owo$server());
        });
        if (!ENABLED) {
            registrar.configurationToClient(HandshakeOff.ID, StreamCodec.unit((Object)new HandshakeOff()), (payload, context) -> {});
        }
    }

    public static void onDisconnect() {
        QUERY_RECEIVED = false;
        QueuedChannelSet.channels = null;
    }

    public static boolean isValidClient() {
        return ENABLED && QUERY_RECEIVED;
    }

    private static void configureStart(ServerConfigurationPacketListenerImpl handler, MinecraftServer server) {
        if (!ENABLED) {
            return;
        }
        if (NetworkRegistry.hasChannel((ICommonPacketListener)handler, (ResourceLocation)OFF_CHANNEL_ID)) {
            Owo.LOGGER.info("[Handshake] Handshake disabled by client, skipping");
            return;
        }
        if (!NetworkRegistry.hasChannel((ICommonPacketListener)handler, (ResourceLocation)CHANNEL_ID)) {
            if (!HANDSHAKE_REQUIRED) {
                return;
            }
            handler.disconnect((Component)TextOps.concat((Component)PREFIX, Component.nullToEmpty((String)"incompatible client")));
            Owo.LOGGER.info("[Handshake] Handshake failed, client doesn't understand channel packet");
            return;
        }
        Map<ResourceLocation, Integer> optionalChannels = OwoHandshake.formatHashes(OwoNetChannel.OPTIONAL_CHANNELS, OwoHandshake::hashChannel);
        handler.send((CustomPacketPayload)new HandshakeRequest(optionalChannels));
        Owo.LOGGER.info("[Handshake] Sending channel packet");
    }

    private static void syncClient(HandshakeRequest request, IPayloadContext context) {
        Owo.LOGGER.info("[Handshake] Sending client channels");
        QUERY_RECEIVED = true;
        QueuedChannelSet.channels = OwoHandshake.filterOptionalServices(request.optionalChannels(), OwoNetChannel.REGISTERED_CHANNELS, OwoHandshake::hashChannel);
        Map<ResourceLocation, Integer> requiredChannels = OwoHandshake.formatHashes(OwoNetChannel.REQUIRED_CHANNELS, OwoHandshake::hashChannel);
        Map<ResourceLocation, Integer> requiredControllers = OwoHandshake.formatHashes(ParticleSystemController.REGISTERED_CONTROLLERS, OwoHandshake::hashController);
        Map<ResourceLocation, Integer> optionalChannels = OwoHandshake.formatHashes(OwoNetChannel.OPTIONAL_CHANNELS, OwoHandshake::hashChannel);
        context.reply((CustomPacketPayload)new HandshakeResponse(requiredChannels, requiredControllers, optionalChannels));
    }

    private static void syncServer(HandshakeResponse response, IPayloadContext context) {
        Owo.LOGGER.info("[Handshake] Receiving client channels");
        StringBuilder disconnectMessage = new StringBuilder();
        boolean isAllGood = OwoHandshake.verifyReceivedHashes("channels", response.requiredChannels(), OwoNetChannel.REQUIRED_CHANNELS, OwoHandshake::hashChannel, disconnectMessage);
        if (!(isAllGood &= OwoHandshake.verifyReceivedHashes("controllers", response.requiredControllers(), ParticleSystemController.REGISTERED_CONTROLLERS, OwoHandshake::hashController, disconnectMessage))) {
            context.disconnect((Component)TextOps.concat((Component)PREFIX, Component.nullToEmpty((String)disconnectMessage.toString())));
        }
        ((OwoClientConnectionExtension)((ServerCommonNetworkHandlerAccessor)((ServerPayloadContext)context).listener()).owo$getConnection()).owo$setChannelSet(OwoHandshake.filterOptionalServices(response.optionalChannels(), OwoNetChannel.OPTIONAL_CHANNELS, OwoHandshake::hashChannel));
        Owo.LOGGER.info("[Handshake] Handshake completed successfully");
    }

    private static <T> Set<ResourceLocation> filterOptionalServices(Map<ResourceLocation, Integer> remoteMap, Map<ResourceLocation, T> localMap, ToIntFunction<T> hashFunction) {
        HashSet<ResourceLocation> readableServices = new HashSet<ResourceLocation>();
        for (Map.Entry<ResourceLocation, Integer> entry : remoteMap.entrySet()) {
            T service = localMap.get(entry.getKey());
            if (service == null || hashFunction.applyAsInt(service) != entry.getValue().intValue()) continue;
            readableServices.add(entry.getKey());
        }
        return readableServices;
    }

    private static <T> boolean verifyReceivedHashes(String serviceNamePlural, Map<ResourceLocation, Integer> clientMap, Map<ResourceLocation, T> serverMap, ToIntFunction<T> hashFunction, StringBuilder disconnectMessage) {
        boolean isAllGood = true;
        if (!clientMap.keySet().equals(serverMap.keySet())) {
            isAllGood = false;
            Tuple<Set<ResourceLocation>, Set<ResourceLocation>> leftovers = OwoHandshake.findCollisions(clientMap.keySet(), serverMap.keySet());
            if (!((Set)leftovers.getA()).isEmpty()) {
                disconnectMessage.append("server is missing ").append(serviceNamePlural).append(":\n");
                ((Set)leftovers.getA()).forEach(identifier -> disconnectMessage.append("\u00a77").append(identifier).append("\u00a7r\n"));
            }
            if (!((Set)leftovers.getB()).isEmpty()) {
                disconnectMessage.append("client is missing ").append(serviceNamePlural).append(":\n");
                ((Set)leftovers.getB()).forEach(identifier -> disconnectMessage.append("\u00a77").append(identifier).append("\u00a7r\n"));
            }
        }
        boolean hasMismatchedHashes = false;
        for (Map.Entry<ResourceLocation, Integer> entry : clientMap.entrySet()) {
            int localHash;
            T actualServiceObject = serverMap.get(entry.getKey());
            if (actualServiceObject == null || (localHash = hashFunction.applyAsInt(actualServiceObject)) == entry.getValue()) continue;
            if (!hasMismatchedHashes) {
                disconnectMessage.append(serviceNamePlural).append(" with mismatched hashes:\n");
            }
            disconnectMessage.append("\u00a77").append(entry.getKey()).append("\u00a7r\n");
            isAllGood = false;
            hasMismatchedHashes = true;
        }
        return isAllGood;
    }

    private static <T> Map<ResourceLocation, Integer> formatHashes(Map<ResourceLocation, T> values, ToIntFunction<T> hashFunction) {
        HashMap<ResourceLocation, Integer> hashes = new HashMap<ResourceLocation, Integer>();
        for (Map.Entry<ResourceLocation, T> entry : values.entrySet()) {
            hashes.put(entry.getKey(), hashFunction.applyAsInt(entry.getValue()));
        }
        return hashes;
    }

    private static Tuple<Set<ResourceLocation>, Set<ResourceLocation>> findCollisions(Set<ResourceLocation> first, Set<ResourceLocation> second) {
        HashSet firstLeftovers = new HashSet();
        HashSet secondLeftovers = new HashSet();
        first.forEach(identifier -> {
            if (!second.contains(identifier)) {
                firstLeftovers.add(identifier);
            }
        });
        second.forEach(identifier -> {
            if (!first.contains(identifier)) {
                secondLeftovers.add(identifier);
            }
        });
        return new Tuple(firstLeftovers, secondLeftovers);
    }

    private static int hashChannel(OwoNetChannel channel) {
        int serializersHash = 0;
        for (Int2ObjectMap.Entry entry : channel.endecsByIndex.int2ObjectEntrySet()) {
            serializersHash += entry.getIntKey() * 31 + ((OwoNetChannel.IndexedEndec)entry.getValue()).getRecordClass().getName().hashCode();
        }
        return 31 * channel.packetId.id().hashCode() + serializersHash;
    }

    private static int hashController(ParticleSystemController controller) {
        int serializersHash = 0;
        for (Int2ObjectMap.Entry entry : controller.systemsByIndex.int2ObjectEntrySet()) {
            serializersHash += entry.getIntKey();
        }
        return 31 * controller.channelId.hashCode() + serializersHash;
    }

    public static boolean handshakeRequired() {
        return HANDSHAKE_REQUIRED;
    }

    private record HandshakeResponse(Map<ResourceLocation, Integer> requiredChannels, Map<ResourceLocation, Integer> requiredControllers, Map<ResourceLocation, Integer> optionalChannels) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<HandshakeResponse> ID = new CustomPacketPayload.Type(CHANNEL_ID);
        public static final Endec<HandshakeResponse> ENDEC = StructEndecBuilder.of((StructField)CHANNEL_HASHES_ENDEC.fieldOf("requiredChannels", HandshakeResponse::requiredChannels), (StructField)CHANNEL_HASHES_ENDEC.fieldOf("requiredControllers", HandshakeResponse::requiredControllers), (StructField)CHANNEL_HASHES_ENDEC.fieldOf("optionalChannels", HandshakeResponse::optionalChannels), HandshakeResponse::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }

    public record HandshakeRequest(Map<ResourceLocation, Integer> optionalChannels) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<HandshakeRequest> ID = new CustomPacketPayload.Type(CHANNEL_ID);
        public static final Endec<HandshakeRequest> ENDEC = StructEndecBuilder.of((StructField)CHANNEL_HASHES_ENDEC.fieldOf("optionalChannels", HandshakeRequest::optionalChannels), HandshakeRequest::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }

    public record HandshakeOff() implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<HandshakeOff> ID = new CustomPacketPayload.Type(OFF_CHANNEL_ID);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }
}

