/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization.format.nbt;

import com.google.common.collect.MapMaker;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SelfDescribedSerializer;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.util.RecursiveSerializer;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.VarInt;
import net.minecraft.network.VarLong;
import org.apache.commons.lang3.mutable.MutableObject;

public class NbtSerializer
extends RecursiveSerializer<Tag>
implements SelfDescribedSerializer<Tag> {
    protected Tag prefix;
    private final Set<Tag> encodedOptionals = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());

    protected NbtSerializer(Tag prefix) {
        super((Object)EndTag.INSTANCE);
        this.prefix = prefix;
    }

    public static NbtSerializer of(Tag prefix) {
        return new NbtSerializer(prefix);
    }

    public static NbtSerializer of() {
        return NbtSerializer.of(null);
    }

    public void writeByte(SerializationContext ctx, byte value) {
        this.consume(ByteTag.valueOf((byte)value));
    }

    public void writeShort(SerializationContext ctx, short value) {
        this.consume(ShortTag.valueOf((short)value));
    }

    public void writeInt(SerializationContext ctx, int value) {
        this.consume(IntTag.valueOf((int)value));
    }

    public void writeLong(SerializationContext ctx, long value) {
        this.consume(LongTag.valueOf((long)value));
    }

    public void writeFloat(SerializationContext ctx, float value) {
        this.consume(FloatTag.valueOf((float)value));
    }

    public void writeDouble(SerializationContext ctx, double value) {
        this.consume(DoubleTag.valueOf((double)value));
    }

    public void writeVarInt(SerializationContext ctx, int value) {
        this.consume(switch (VarInt.getByteSize((int)value)) {
            case 0, 1 -> ByteTag.valueOf((byte)((byte)value));
            case 2 -> ShortTag.valueOf((short)((short)value));
            default -> IntTag.valueOf((int)value);
        });
    }

    public void writeVarLong(SerializationContext ctx, long value) {
        this.consume(switch (VarLong.getByteSize((long)value)) {
            case 0, 1 -> ByteTag.valueOf((byte)((byte)value));
            case 2 -> ShortTag.valueOf((short)((short)value));
            case 3, 4 -> IntTag.valueOf((int)((int)value));
            default -> LongTag.valueOf((long)value);
        });
    }

    public void writeBoolean(SerializationContext ctx, boolean value) {
        this.consume(ByteTag.valueOf((boolean)value));
    }

    public void writeString(SerializationContext ctx, String value) {
        this.consume(StringTag.valueOf((String)value));
    }

    public void writeBytes(SerializationContext ctx, byte[] bytes) {
        this.consume(new ByteArrayTag(bytes));
    }

    public <V> void writeOptional(SerializationContext ctx, Endec<V> endec, Optional<V> optional) {
        MutableObject frameData = new MutableObject();
        this.frame(encoded -> {
            try (Serializer.Struct struct = this.struct();){
                struct.field("present", ctx, Endec.BOOLEAN, (Object)optional.isPresent());
                optional.ifPresent(value -> struct.field("value", ctx, endec, value));
            }
            Tag compound = (Tag)encoded.require("optional representation");
            this.encodedOptionals.add(compound);
            frameData.setValue((Object)compound);
        });
        this.consume((Tag)frameData.getValue());
    }

    public <E> Serializer.Sequence<E> sequence(SerializationContext ctx, Endec<E> elementEndec, int size) {
        return new Sequence<E>(ctx, elementEndec);
    }

    public <V> Serializer.Map<V> map(SerializationContext ctx, Endec<V> valueEndec, int size) {
        return new Map<V>(ctx, valueEndec);
    }

    public Serializer.Struct struct() {
        return new Map(null, null);
    }

    private class Sequence<V>
    implements Serializer.Sequence<V> {
        private final SerializationContext ctx;
        private final Endec<V> valueEndec;
        private final ListTag result;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Sequence(SerializationContext ctx, Endec<V> valueEndec) {
            this.ctx = ctx;
            this.valueEndec = valueEndec;
            if (NbtSerializer.this.prefix != null) {
                ListTag prefixList;
                Tag tag = NbtSerializer.this.prefix;
                if (!(tag instanceof ListTag)) throw new IllegalStateException("Incompatible prefix of type " + NbtSerializer.this.prefix.getClass().getSimpleName() + " provided for NBT sequence");
                this.result = prefixList = (ListTag)tag;
                return;
            } else {
                this.result = new ListTag();
            }
        }

        public void element(V element) {
            NbtSerializer.this.frame(encoded -> {
                this.valueEndec.encode(this.ctx, (Serializer)NbtSerializer.this, element);
                this.result.add((Object)((Tag)encoded.require("sequence element")));
            });
        }

        public void end() {
            NbtSerializer.this.consume(this.result);
        }
    }

    private class Map<V>
    implements Serializer.Map<V>,
    Serializer.Struct {
        private final SerializationContext ctx;
        private final Endec<V> valueEndec;
        private final CompoundTag result;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Map(SerializationContext ctx, Endec<V> valueEndec) {
            this.ctx = ctx;
            this.valueEndec = valueEndec;
            if (NbtSerializer.this.prefix != null) {
                CompoundTag prefixMap;
                Tag tag = NbtSerializer.this.prefix;
                if (!(tag instanceof CompoundTag)) throw new IllegalStateException("Incompatible prefix of type " + NbtSerializer.this.prefix.getClass().getSimpleName() + " provided for NBT map/struct");
                this.result = prefixMap = (CompoundTag)tag;
                return;
            } else {
                this.result = new CompoundTag();
            }
        }

        public void entry(String key, V value) {
            NbtSerializer.this.frame(encoded -> {
                this.valueEndec.encode(this.ctx, (Serializer)NbtSerializer.this, value);
                this.result.put(key, (Tag)encoded.require("map value"));
            });
        }

        public <F> Serializer.Struct field(String name, SerializationContext ctx, Endec<F> endec, F value, boolean mayOmit) {
            NbtSerializer.this.frame(encoded -> {
                endec.encode(ctx, (Serializer)NbtSerializer.this, value);
                Tag element = (Tag)encoded.require("struct field");
                if (mayOmit && NbtSerializer.this.encodedOptionals.contains(element)) {
                    CompoundTag nbtCompound = (CompoundTag)element;
                    if (!nbtCompound.getBooleanOr("present", false)) {
                        return;
                    }
                    element = nbtCompound.get("value");
                }
                this.result.put(name, element);
            });
            return this;
        }

        public void end() {
            NbtSerializer.this.consume(this.result);
        }
    }
}

