/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.base;

import com.mojang.blaze3d.platform.Window;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Size;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.function.Supplier;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public abstract class BaseOwoToast<R extends ParentComponent>
implements Toast {
    protected final R rootComponent;
    protected final VisibilityPredicate<R> visibilityPredicate;
    protected int virtualWidth = 1000;
    protected int virtualHeight = 1000;
    private Toast.Visibility visibility = Toast.Visibility.HIDE;

    protected BaseOwoToast(Supplier<R> components, VisibilityPredicate<R> predicate) {
        this.rootComponent = (ParentComponent)components.get();
        this.visibilityPredicate = predicate;
        this.rootComponent.inflate(Size.of(this.virtualWidth, this.virtualHeight));
        this.rootComponent.mount(null, 0, 0);
    }

    protected BaseOwoToast(Supplier<R> rootComponent, Duration timeout) {
        this(rootComponent, VisibilityPredicate.timeout(timeout));
    }

    public void update(ToastManager manager, long time) {
        float delta = Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaTicks();
        Minecraft client = manager.getMinecraft();
        Window window = client.getWindow();
        int mouseX = -1000;
        int mouseY = -1000;
        this.rootComponent.update(delta, mouseX, mouseY);
        this.visibility = this.visibilityPredicate.test(this, time);
    }

    public Toast.Visibility getWantedVisibility() {
        return this.visibility;
    }

    public void render(GuiGraphics context, Font textRenderer, long startTime) {
        DeltaTracker tickCounter = Minecraft.getInstance().getDeltaTracker();
        this.rootComponent.draw(OwoUIDrawContext.of(context), -1000, -1000, tickCounter.getGameTimeDeltaPartialTick(false), tickCounter.getGameTimeDeltaTicks());
    }

    public int height() {
        return this.rootComponent.fullSize().height();
    }

    public int width() {
        return this.rootComponent.fullSize().width();
    }

    @FunctionalInterface
    public static interface VisibilityPredicate<R extends ParentComponent> {
        public Toast.Visibility test(BaseOwoToast<R> var1, long var2);

        public static <R extends ParentComponent> VisibilityPredicate<R> timeout(Duration timeout) {
            return (toast, startTime) -> System.currentTimeMillis() - startTime <= timeout.get(ChronoUnit.MILLIS) ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
        }
    }
}

