/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.component;

import io.wispforest.owo.mixin.ui.access.TextFieldWidgetAccessor;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.util.EventSource;
import io.wispforest.owo.util.EventStream;
import io.wispforest.owo.util.Observable;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import org.w3c.dom.Element;

public class TextBoxComponent
extends EditBox {
    protected final Observable<Boolean> showsBackground = Observable.of(((TextFieldWidgetAccessor)((Object)this)).owo$drawsBackground());
    protected final Observable<String> textValue = Observable.of("");
    protected final EventStream<OnChanged> changedEvents = OnChanged.newStream();

    protected TextBoxComponent(Sizing horizontalSizing) {
        super(Minecraft.getInstance().font, 0, 0, 0, 0, (Component)Component.empty());
        this.textValue.observe(this.changedEvents.sink()::onChanged);
        this.sizing(horizontalSizing, Sizing.content());
        this.showsBackground.observe(a -> this.widgetWrapper().notifyParentIfMounted());
    }

    @Deprecated(forRemoval=true)
    public void setResponder(Consumer<String> changedListener) {
        super.setResponder(changedListener);
    }

    public void drawFocusHighlight(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
    }

    public boolean keyPressed(KeyEvent input) {
        boolean result = super.keyPressed(input);
        if (input.isCycleFocus()) {
            this.insertText("    ");
            return true;
        }
        return result;
    }

    public void updateX(int x) {
        super.updateX(x);
        ((TextFieldWidgetAccessor)((Object)this)).owo$updateTextPosition();
    }

    public void updateY(int y) {
        super.updateY(y);
        ((TextFieldWidgetAccessor)((Object)this)).owo$updateTextPosition();
    }

    public void setBordered(boolean drawsBackground) {
        super.setBordered(drawsBackground);
        this.showsBackground.set(drawsBackground);
    }

    public EventSource<OnChanged> onChanged() {
        return this.changedEvents.source();
    }

    public TextBoxComponent text(String text) {
        this.setValue(text);
        this.moveCursorToStart(false);
        return this;
    }

    public void parseProperties(UIModel spec, Element element, Map<String, Element> children) {
        super.parseProperties(spec, element, children);
        UIParsing.apply(children, "show-background", UIParsing::parseBool, this::setBordered);
        UIParsing.apply(children, "max-length", UIParsing::parseUnsignedInt, arg_0 -> ((TextBoxComponent)this).setMaxLength(arg_0));
        UIParsing.apply(children, "text", e -> e.getTextContent().strip(), this::text);
    }

    protected CursorStyle owo$preferredCursorStyle() {
        return CursorStyle.TEXT;
    }

    public static interface OnChanged {
        public void onChanged(String var1);

        public static EventStream<OnChanged> newStream() {
            return new EventStream<OnChanged>(subscribers -> value -> {
                for (OnChanged subscriber : subscribers) {
                    subscriber.onChanged(value);
                }
            });
        }
    }
}

