/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.parsing;

import io.wispforest.owo.ui.base.BaseUIModelScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.parsing.UIModelLoader;
import io.wispforest.owo.ui.util.CommandOpenedScreen;
import io.wispforest.owo.ui.util.UISounds;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class ConfigureHotReloadScreen
extends BaseUIModelScreen<FlowLayout>
implements CommandOpenedScreen {
    @Nullable
    private final Screen parent;
    private final ResourceLocation modelId;
    @Nullable
    private Path reloadLocation;
    private LabelComponent fileNameLabel;

    public ConfigureHotReloadScreen(ResourceLocation modelId, @Nullable Screen parent) {
        super(FlowLayout.class, BaseUIModelScreen.DataSource.asset(ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"configure_hot_reload")));
        this.parent = parent;
        this.modelId = modelId;
        this.reloadLocation = UIModelLoader.getHotReloadPath(this.modelId);
    }

    @Override
    protected void build(FlowLayout rootComponent) {
        rootComponent.childById(LabelComponent.class, "ui-model-label").text((Component)Component.translatable((String)"text.owo.configure_hot_reload.model", (Object[])new Object[]{this.modelId}));
        this.fileNameLabel = rootComponent.childById(LabelComponent.class, "file-name-label");
        this.updateFileNameLabel();
        rootComponent.childById(ButtonComponent.class, "choose-button").onPress(button -> CompletableFuture.runAsync(() -> {
            String newPath = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)"Choose UI Model source", null, null, null, (boolean)false);
            if (newPath != null) {
                this.reloadLocation = Path.of(newPath, new String[0]);
            }
        }, (Executor)Util.backgroundExecutor()).whenComplete((unused, throwable) -> this.updateFileNameLabel()));
        rootComponent.childById(ButtonComponent.class, "save-button").onPress(button -> {
            UIModelLoader.setHotReloadPath(this.modelId, this.reloadLocation);
            this.onClose();
        });
        rootComponent.childById(LabelComponent.class, "close-label").mouseDown().subscribe((click, doubled) -> {
            UISounds.playInteractionSound();
            this.onClose();
            return true;
        });
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    private void updateFileNameLabel() {
        this.fileNameLabel.text((Component)Component.translatable((String)"text.owo.configure_hot_reload.reload_from", (Object[])new Object[]{this.reloadLocation == null ? Component.translatable((String)"text.owo.configure_hot_reload.reload_from.unset") : this.reloadLocation}));
    }
}

