/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.parsing;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonGrammar;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.JsonPrimitive;
import blue.endless.jankson.api.SyntaxError;
import io.wispforest.owo.Owo;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.ui.parsing.UIModel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.neoforged.fml.loading.FMLPaths;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;

public class UIModelLoader
implements ResourceManagerReloadListener {
    private static final Map<ResourceLocation, UIModel> LOADED_MODELS = new HashMap<ResourceLocation, UIModel>();
    private static final Jankson JANKSON = Jankson.builder().registerSerializer(Path.class, (path, marshaller) -> JsonPrimitive.of((String)path.toString())).registerSerializer(ResourceLocation.class, (identifier, marshaller) -> new JsonPrimitive((Object)identifier.toString())).build();
    private static final Path HOT_RELOAD_LOCATIONS_PATH = FMLPaths.CONFIGDIR.get().resolve("owo_ui_hot_reload_locations.json5");
    private static final Map<ResourceLocation, Path> HOT_RELOAD_LOCATIONS = new HashMap<ResourceLocation, Path>();
    private static boolean loadedOnce = false;

    @Nullable
    public static UIModel get(ResourceLocation id) {
        if (Owo.DEBUG && HOT_RELOAD_LOCATIONS.containsKey(id)) {
            UIModel uIModel;
            block9: {
                InputStream stream = Files.newInputStream(HOT_RELOAD_LOCATIONS.get(id), new OpenOption[0]);
                try {
                    uIModel = UIModel.load(stream);
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | ParserConfigurationException | SAXException e) {
                        Minecraft.getInstance().player.displayClientMessage((Component)TextOps.concat(Owo.PREFIX, (Component)TextOps.withFormatting("hot ui model reload failed, check the log for details", ChatFormatting.RED)), false);
                        Owo.LOGGER.error("Hot UI model reload failed", (Throwable)e);
                    }
                }
                stream.close();
            }
            return uIModel;
        }
        return UIModelLoader.getPreloaded(id);
    }

    @Nullable
    public static UIModel getPreloaded(ResourceLocation id) {
        return LOADED_MODELS.getOrDefault(id, null);
    }

    public static void setHotReloadPath(ResourceLocation modelId, @Nullable Path reloadPath) {
        if (reloadPath != null) {
            HOT_RELOAD_LOCATIONS.put(modelId, reloadPath);
        } else {
            HOT_RELOAD_LOCATIONS.remove(modelId);
        }
        try {
            Files.writeString(HOT_RELOAD_LOCATIONS_PATH, (CharSequence)JANKSON.toJson(HOT_RELOAD_LOCATIONS).toJson(JsonGrammar.JSON5), new OpenOption[0]);
        }
        catch (IOException e) {
            Owo.LOGGER.warn("Could not save hot reload locations", (Throwable)e);
        }
    }

    @Nullable
    public static Path getHotReloadPath(ResourceLocation modelId) {
        return HOT_RELOAD_LOCATIONS.get(modelId);
    }

    public static Set<ResourceLocation> allLoadedModels() {
        return Collections.unmodifiableSet(LOADED_MODELS.keySet());
    }

    public static ResourceLocation getFabricId() {
        return ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"ui-model-loader");
    }

    public void onResourceManagerReload(ResourceManager manager) {
        LOADED_MODELS.clear();
        manager.listResources("owo_ui", identifier -> identifier.getPath().endsWith(".xml")).forEach((resourceId, resource) -> {
            try {
                ResourceLocation modelId = ResourceLocation.fromNamespaceAndPath((String)resourceId.getNamespace(), (String)resourceId.getPath().substring(7, resourceId.getPath().length() - 4));
                LOADED_MODELS.put(modelId, UIModel.load(resource.open()));
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                Owo.LOGGER.error("Could not parse UI model {}", resourceId, (Object)e);
            }
        });
        loadedOnce = true;
    }

    @ApiStatus.Internal
    public static boolean hasCompletedInitialLoad() {
        return loadedOnce;
    }

    static {
        if (Owo.DEBUG && Files.exists(HOT_RELOAD_LOCATIONS_PATH, new LinkOption[0])) {
            try (InputStream stream = Files.newInputStream(HOT_RELOAD_LOCATIONS_PATH, new OpenOption[0]);){
                JsonObject associations = JANKSON.load(stream);
                associations.forEach((key, value) -> {
                    if (!(value instanceof JsonPrimitive)) {
                        return;
                    }
                    JsonPrimitive primitive = (JsonPrimitive)value;
                    HOT_RELOAD_LOCATIONS.put(ResourceLocation.parse((String)key), Path.of(primitive.asString(), new String[0]));
                });
            }
            catch (SyntaxError | IOException throwable) {
                // empty catch block
            }
        }
    }
}

