/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.renderstate;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.feature.FeatureRenderDispatcher;
import net.minecraft.client.renderer.state.CameraRenderState;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;

public record EntityElementRenderState(EntityRenderState entityState, Matrix4f transform, ScreenRectangle bounds, ScreenRectangle scissorArea) implements PictureInPictureRenderState
{
    private final ScreenRectangle bounds;

    public int x0() {
        return this.bounds.left();
    }

    public int x1() {
        return this.bounds.right();
    }

    public int y0() {
        return this.bounds.top();
    }

    public int y1() {
        return this.bounds.bottom();
    }

    public float scale() {
        return 1.0f;
    }

    @Nullable
    public ScreenRectangle bounds() {
        return this.scissorArea != null ? this.scissorArea.intersection(this.bounds) : this.bounds;
    }

    public static class Renderer
    extends PictureInPictureRenderer<EntityElementRenderState> {
        private final EntityRenderDispatcher renderManager = Minecraft.getInstance().getEntityRenderDispatcher();

        protected Renderer(MultiBufferSource.BufferSource vertexConsumers) {
            super(vertexConsumers);
        }

        public Class<EntityElementRenderState> getRenderStateClass() {
            return EntityElementRenderState.class;
        }

        protected void render(EntityElementRenderState state, PoseStack matrices) {
            Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ENTITY_IN_UI);
            matrices.mulPose((Matrix4fc)state.transform);
            CameraRenderState camera = new CameraRenderState();
            camera.orientation = state.transform.invert().getUnnormalizedRotation(new Quaternionf());
            FeatureRenderDispatcher dispatcher = Minecraft.getInstance().gameRenderer.getFeatureRenderDispatcher();
            this.renderManager.submit(state.entityState, camera, 0.0, 0.0, 0.0, matrices, (SubmitNodeCollector)dispatcher.getSubmitNodeStorage());
            dispatcher.renderAllFeatures();
        }

        protected String getTextureLabel() {
            return "owo-ui_entity";
        }
    }
}

