/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.AddServerReloadListenersEvent;
import net.neoforged.neoforge.resource.VanillaServerListeners;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class RecipeRemainderStorage {
    private static final Map<ResourceLocation, Map<Item, ItemStack>> REMAINDERS = new HashMap<ResourceLocation, Map<Item, ItemStack>>();

    private RecipeRemainderStorage() {
    }

    public static void store(ResourceLocation recipe, Map<Item, ItemStack> remainders) {
        REMAINDERS.put(recipe, remainders);
    }

    public static boolean has(ResourceLocation recipe) {
        return REMAINDERS.containsKey(recipe);
    }

    public static Map<Item, ItemStack> get(ResourceLocation recipe) {
        return REMAINDERS.get(recipe);
    }

    public static void addReloadListener(AddServerReloadListenersEvent event) {
        event.addListener(ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"reload_hook_recipe_remainders"), (PreparableReloadListener)((ResourceManagerReloadListener)manager -> REMAINDERS.clear()));
        event.addDependency(ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"reload_hook_recipe_remainders"), VanillaServerListeners.RECIPES);
    }
}

