package io.wispforest.owo.mixin.recipe_remainders;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import io.wispforest.owo.util.RecipeRemainderStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

@Mixin(ResultSlot.class)
public class CraftingResultSlotMixin {

    @Shadow
    @Final
    private Player player;

    @Inject(method = "onTakeItem", at = @At(value = "INVOKE", target = "Lnet/minecraft/inventory/RecipeInputInventory;setStack(ILnet/minecraft/item/ItemStack;)V", ordinal = 1), locals = LocalCapture.CAPTURE_FAILHARD)
    private void fixRemainderStacking(Player player, ItemStack stack, CallbackInfo ci, CraftingInput.Positioned positioned, CraftingInput craftingRecipeInput, int i, int j, NonNullList defaultedList, int k, int l, int m, ItemStack itemStack, ItemStack remainderStack) {
        if (remainderStack.getCount() > remainderStack.getMaxStackSize()) {
            int excess = remainderStack.getCount() - remainderStack.getMaxStackSize();
            remainderStack.shrink(excess);

            var insertStack = remainderStack.copy();
            insertStack.setCount(excess);

            if (!this.player.getInventory().add(insertStack)) {
                this.player.drop(insertStack, false);
            }
        }
    }

    @WrapOperation(method = "getRecipeRemainders", at = @At(value = "INVOKE", target = "Lnet/minecraft/recipe/ServerRecipeManager;getFirstMatch(Lnet/minecraft/recipe/RecipeType;Lnet/minecraft/recipe/input/RecipeInput;Lnet/minecraft/world/World;)Ljava/util/Optional;"))
    private <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> captureRecipeEntry(RecipeManager instance, RecipeType<T> type, I input, Level world, Operation<Optional<RecipeHolder<T>>> original, @Share("owo_recipe_entry") LocalRef<Optional<RecipeHolder<T>>> recipeEntry) {
        var entry = original.call(instance, type, input, world);

        recipeEntry.set(entry);

        return entry;
    }

    @WrapOperation(method = "getRecipeRemainders", at = @At(value = "INVOKE", target = "Ljava/util/Optional;map(Ljava/util/function/Function;)Ljava/util/Optional;"))
    private <I extends RecipeInput, T extends Recipe<I>> Optional<NonNullList<ItemStack>> addRecipeSpecificRemainders(Optional<T> instance, Function<? super T, ? extends NonNullList<ItemStack>> mapper, Operation<Optional<NonNullList<ItemStack>>> original, @Share("owo_recipe_entry") LocalRef<Optional<RecipeHolder<?>>> recipeEntry, @Local(argsOnly = true) CraftingInput input) {
        var recipeEntryOptional = recipeEntry.get();

        return original.call(instance, mapper)
                .map(defaultList -> {
                    var recipeId = recipeEntryOptional.get().id().location();

                    if(RecipeRemainderStorage.has(recipeId)) {
                        var remainders = defaultList;
                        var owoRemainders = RecipeRemainderStorage.get(recipeId);

                        for (int i = 0; i < remainders.size(); ++i) {
                            var item = input.getItem(i).getItem();
                            if (!owoRemainders.containsKey(item)) continue;

                            remainders.set(i, owoRemainders.get(item).copy());
                        }
                    }

                    return defaultList;
                });
    }
}
