package io.wispforest.owo.util;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.AddServerReloadListenersEvent;
import net.neoforged.neoforge.resource.VanillaServerListeners;
import org.jetbrains.annotations.ApiStatus;

import java.util.HashMap;
import java.util.Map;

@ApiStatus.Internal
public final class RecipeRemainderStorage {

    private RecipeRemainderStorage() {}

    private static final Map<ResourceLocation, Map<Item, ItemStack>> REMAINDERS = new HashMap<>();

    public static void store(ResourceLocation recipe, Map<Item, ItemStack> remainders) {
        REMAINDERS.put(recipe, remainders);
    }

    public static boolean has(ResourceLocation recipe) {
        return REMAINDERS.containsKey(recipe);
    }

    public static Map<Item, ItemStack> get(ResourceLocation recipe) {
        return REMAINDERS.get(recipe);
    }

    public static void addReloadListener(AddServerReloadListenersEvent event) {
        event.addListener(ResourceLocation.fromNamespaceAndPath("owo", "reload_hook_recipe_remainders"), (ResourceManagerReloadListener) manager -> REMAINDERS.clear());
        event.addDependency(ResourceLocation.fromNamespaceAndPath("owo", "reload_hook_recipe_remainders"), VanillaServerListeners.RECIPES);
    }
}
